package org.gcube.informationsystem.resourceregistry.schema;

import java.util.Collection;

import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.knowledge.TypesDiscoverer;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.types.reference.Type;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class RRCCTypesDiscoverer implements TypesDiscoverer<Type> {

	/**
	 * Reference to the Resource Registry Schema Client implementation used for type discovery operations.
	 */
	protected ResourceRegistrySchemaClientImpl rrsc;
	
	/**
	 * Creates a new types discoverer instance.
	 * 
	 * @param rrsc the Resource Registry Schema Client implementation to use for type discovery
	 */
	public RRCCTypesDiscoverer(ResourceRegistrySchemaClientImpl rrsc) {
		this.rrsc = rrsc;
	}
	
	@Override
	public Collection<Type> discover(AccessType accessType) {
		try {
			return rrsc.getTypeFromServer(accessType.getTypeClass(), true);
		} catch (ResourceRegistryException e) {
			throw new RuntimeException(e);
		}
	}

}
