/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest.requests;

import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.gcube.informationsystem.resourceregistry.api.request.BaseRequestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRequestInfo
extends BaseRequestInfo {
    protected static Logger logger = LoggerFactory.getLogger(ServerRequestInfo.class);
    protected UriInfo uriInfo = null;

    public ServerRequestInfo() {
    }

    public ServerRequestInfo(int offset, int limit) {
        super(Integer.valueOf(offset), Integer.valueOf(limit));
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public boolean isAllowed(String queryParameterKey) {
        switch (queryParameterKey) {
            case "includeMeta": {
                return true;
            }
            case "allMeta": {
                return true;
            }
            case "includeContexts": {
                return true;
            }
            case "hierarchical": {
                return true;
            }
            case "limit": {
                return true;
            }
            case "offset": {
                return true;
            }
        }
        return true;
    }

    public boolean setIfAllowed(String queryParameterKey, boolean bool, boolean forceAllowed) {
        switch (queryParameterKey) {
            case "includeMeta": {
                if (forceAllowed || this.isAllowed(queryParameterKey)) {
                    this.includeMeta = bool;
                }
                return this.includeMeta;
            }
            case "allMeta": {
                if (forceAllowed || this.isAllowed(queryParameterKey)) {
                    this.allMeta = bool;
                }
                return this.allMeta;
            }
            case "includeContexts": {
                if (forceAllowed || this.isAllowed(queryParameterKey)) {
                    this.includeContexts = bool;
                }
                return this.includeContexts;
            }
            case "hierarchical": {
                if (forceAllowed || this.isAllowed(queryParameterKey)) {
                    this.hierarchicalMode = bool;
                }
                return this.hierarchicalMode;
            }
        }
        return false;
    }

    public boolean setIfAllowed(String queryParameterKey, boolean bool) {
        return this.setIfAllowed(queryParameterKey, bool, false);
    }

    public int setIfAllowed(String queryParameterKey, int integer, boolean forceAllowed) {
        switch (queryParameterKey) {
            case "limit": {
                if (forceAllowed || this.isAllowed(queryParameterKey)) {
                    this.limit = integer;
                }
                return this.limit;
            }
            case "offset": {
                if (forceAllowed || this.isAllowed(queryParameterKey)) {
                    this.offset = integer;
                }
                return this.offset;
            }
        }
        return -1;
    }

    public int setIfAllowed(String queryParameterKey, int integer) {
        return this.setIfAllowed(queryParameterKey, integer, false);
    }

    public void checkBooleanQueryParameter(String queryParameterKey) {
        try {
            List queryParameterList = (List)this.uriInfo.getQueryParameters().get((Object)queryParameterKey);
            if (queryParameterList != null && queryParameterList.size() > 0) {
                String booleanString = (String)queryParameterList.get(0);
                boolean bool = Boolean.valueOf(booleanString);
                this.setIfAllowed(queryParameterKey, bool);
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to properly set " + queryParameterKey, (Object)t.getMessage());
        }
    }

    public void checkIntegerQueryParameter(String queryParameterKey) {
        this.checkIntegerQueryParameter(queryParameterKey, null);
    }

    public void checkIntegerQueryParameter(String queryParameterKey, Integer defaultValue) {
        try {
            List queryParameterList = (List)this.uriInfo.getQueryParameters().get((Object)queryParameterKey);
            if (queryParameterList != null && queryParameterList.size() > 0) {
                String intString = (String)queryParameterList.get(0);
                int integer = Integer.valueOf(intString);
                this.setIfAllowed(queryParameterKey, integer);
            } else if (defaultValue != null) {
                this.setIfAllowed(queryParameterKey, defaultValue.intValue(), true);
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to properly set " + queryParameterKey, (Object)t.getMessage());
        }
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public void checkAllBooleanQueryParameters() {
        this.checkAllIncludeQueryParameters();
        this.checkBooleanQueryParameter("hierarchical");
    }

    public void checkAllIncludeQueryParameters() {
        this.checkIncludeAllMetaQueryParameters();
        this.checkBooleanQueryParameter("includeContexts");
    }

    public void checkIncludeAllMetaQueryParameters() {
        this.checkBooleanQueryParameter("includeMeta");
        this.checkBooleanQueryParameter("allMeta");
    }

    public void checkLimitOffset(int offset, int limit) {
        this.checkIntegerQueryParameter("offset", Integer.valueOf(offset));
        this.checkIntegerQueryParameter("limit", Integer.valueOf(limit));
    }

    public void checkLimitOffset() {
        this.checkLimitOffset(DEFAULT_OFFSET.intValue(), DEFAULT_LIMIT.intValue());
    }
}

