/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.base;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import jakarta.activation.UnsupportedDataTypeException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.base.properties.PropertyElementManagement;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.FacetManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ElementManagementUtility {
    private static Logger logger = LoggerFactory.getLogger(ElementManagementUtility.class);

    public static OElement getAnyElementByUUID(UUID uuid) throws NotFoundException, ResourceRegistryException {
        try {
            return OrientDBUtility.getElementByUUIDAsAdmin(null, (UUID)uuid, OVertex.class);
        }
        catch (NotFoundException e) {
            return OrientDBUtility.getElementByUUIDAsAdmin(null, (UUID)uuid, OEdge.class);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static OElement getAnyElementByUUID(ODatabaseDocument oDatabaseDocument, UUID uuid) throws NotFoundException, ResourceRegistryException {
        try {
            return OrientDBUtility.getElementByUUID((ODatabaseDocument)oDatabaseDocument, null, (UUID)uuid, OVertex.class);
        }
        catch (NotFoundException e) {
            return OrientDBUtility.getElementByUUID((ODatabaseDocument)oDatabaseDocument, null, (UUID)uuid, OEdge.class);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static EntityManagement<?, ?> getEntityManagement(Environment workingContext, ODatabaseDocument oDatabaseDocument, OVertex vertex) throws ResourceRegistryException {
        if (oDatabaseDocument == null) {
            throw new ResourceRegistryException(ODatabaseDocument.class.getSimpleName() + "instance is null. This is really strange and should not occur. Please contact the system administrator.");
        }
        if (vertex == null) {
            throw new ResourceRegistryException(OVertex.class.getSimpleName() + "instance is null. This is really strange and should not occur. Please contact the system administrator.");
        }
        OClass oClass = null;
        try {
            oClass = ElementManagementUtility.getOClass((OElement)vertex);
        }
        catch (Exception e) {
            String error = "Unable to detect type of %s. %s".formatted(vertex.toString(), "This is really strange and should not occur. Please contact the system administrator.");
            logger.error(error, (Throwable)e);
            throw new ResourceRegistryException(error);
        }
        ResourceManagement entityManagement = null;
        if (oClass.isSubClassOf("Resource")) {
            entityManagement = new ResourceManagement();
        } else if (oClass.isSubClassOf("Facet")) {
            entityManagement = new FacetManagement();
        } else {
            String error = "{%s is not a %s nor a %s. %s".formatted(vertex, "Resource", "Facet", "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        entityManagement.setODatabaseDocument(oDatabaseDocument);
        entityManagement.setWorkingEnvironment(workingContext);
        entityManagement.setElement((OElement)vertex);
        return entityManagement;
    }

    public static RelationManagement<?, ?> getRelationManagement(Environment workingContext, ODatabaseDocument oDatabaseDocument, OEdge edge) throws ResourceRegistryException {
        if (oDatabaseDocument == null) {
            throw new ResourceRegistryException(ODatabaseDocument.class.getSimpleName() + "instance is null. This is really strange and should not occur. Please contact the system administrator.");
        }
        if (edge == null) {
            throw new ResourceRegistryException(OEdge.class.getSimpleName() + "instance is null. This is really strange and should not occur. Please contact the system administrator.");
        }
        OClass oClass = ElementManagementUtility.getOClass((OElement)edge);
        ConsistsOfManagement relationManagement = null;
        if (oClass.isSubClassOf("ConsistsOf")) {
            relationManagement = new ConsistsOfManagement();
        } else if (oClass.isSubClassOf("IsRelatedTo")) {
            relationManagement = new IsRelatedToManagement();
        } else {
            String error = "{%s is not a %s nor a %s. %s".formatted(edge, "ConsistsOf", "IsRelatedTo", "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        relationManagement.setODatabaseDocument(oDatabaseDocument);
        relationManagement.setWorkingEnvironment(workingContext);
        relationManagement.setElement((OElement)edge);
        return relationManagement;
    }

    public static <E extends OElement> E getElementFromOptional(Optional<E> optional) throws ResourceRegistryException {
        if (optional.isPresent()) {
            return (E)((OElement)optional.get());
        }
        throw new ResourceRegistryException("An element not belonging to any defined type should not exists. Please contact the administrator.");
    }

    public static OClass getOClass(OElement oElement) throws ResourceRegistryException {
        Optional optional = oElement.getSchemaType();
        if (optional.isPresent()) {
            return (OClass)optional.get();
        }
        throw new ResourceRegistryException("An element not belonging to any defined type should not exists. Please contact the administrator.");
    }

    public static Object getObjectFromJsonNode(JsonNode value) throws UnsupportedDataTypeException, ResourceRegistryException {
        JsonNodeType jsonNodeType = value.getNodeType();
        switch (1.$SwitchMap$org$gcube$com$fasterxml$jackson$databind$node$JsonNodeType[jsonNodeType.ordinal()]) {
            case 1: {
                return PropertyElementManagement.getPropertyDocument((JsonNode)value);
            }
            case 2: {
                ArrayList<Object> list = new ArrayList<Object>();
                ArrayNode arrayNode = (ArrayNode)value;
                for (JsonNode node : arrayNode) {
                    list.add(ElementManagementUtility.getObjectFromJsonNode((JsonNode)node));
                }
                return list;
            }
            case 3: {
                break;
            }
            case 4: {
                return value.asBoolean();
            }
            case 5: {
                break;
            }
            case 6: {
                if (value.isDouble() || value.isFloat()) {
                    return value.asDouble();
                }
                if (value.isBigInteger() || value.isShort() || value.isInt()) {
                    return value.asInt();
                }
                if (!value.isLong()) break;
                return value.asLong();
            }
            case 7: {
                return value.asText();
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
        return null;
    }
}

