/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.rest.SharingPath;
import org.gcube.informationsystem.resourceregistry.instances.model.OperationValidator;
import org.gcube.informationsystem.utils.TypeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharingOperationValidator
implements OperationValidator {
    protected static Logger logger = LoggerFactory.getLogger(SharingOperationValidator.class);
    protected final Map<UUID, JsonNode> expectedInstances;
    protected final SharingPath.SharingOperation sharingOperation;

    public SharingOperationValidator(Map<UUID, JsonNode> expectedInstances, SharingPath.SharingOperation sharingOperation) {
        this.expectedInstances = expectedInstances;
        this.sharingOperation = sharingOperation;
    }

    public boolean isValidOperation(Map<UUID, JsonNode> affectedInstances) throws ResourceRegistryException {
        Set expectedUUIDSet = this.expectedInstances.keySet();
        HashSet<UUID> affectedUUIDSet = new HashSet<UUID>(affectedInstances.keySet());
        affectedUUIDSet.removeAll(expectedUUIDSet);
        if (affectedUUIDSet.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("To keep the integrity of the IS the operation ");
            stringBuffer.append(this.sharingOperation.toString());
            stringBuffer.append(" affects more instances than the requested by the client. The operation will be aborted. ");
            stringBuffer.append("Additional affected instances are ");
            stringBuffer.append(((Object)affectedUUIDSet).toString());
            String errorMessage = stringBuffer.toString();
            logger.error(errorMessage);
            throw new ResourceRegistryException(errorMessage);
        }
        for (UUID expectedUUID : expectedUUIDSet) {
            String affectedType;
            JsonNode expectedJsonNode = (JsonNode)this.expectedInstances.get(expectedUUID);
            JsonNode affectedJsonNode = affectedInstances.get(expectedUUID);
            if (affectedJsonNode == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("The operation ");
                stringBuffer.append(this.sharingOperation.toString());
                stringBuffer.append(" did not affected the instance with UUID ");
                stringBuffer.append(expectedUUID.toString());
                stringBuffer.append(" ");
                stringBuffer.append(expectedJsonNode);
                stringBuffer.append(". This should not occur. Please contact the administrator.");
                String errorMessage = stringBuffer.toString();
                logger.error(errorMessage);
                throw new ResourceRegistryException(errorMessage);
            }
            String expectedType = TypeUtility.getTypeName((JsonNode)expectedJsonNode);
            if (expectedType.compareTo(affectedType = TypeUtility.getTypeName((JsonNode)affectedJsonNode)) == 0) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The expected type of the instance with UUID ");
            stringBuffer.append(expectedUUID);
            stringBuffer.append(" is ");
            stringBuffer.append(expectedType);
            stringBuffer.append(". Instead the effective instance with such UUID is");
            stringBuffer.append(affectedType);
            stringBuffer.append(". The operation has been aborted.");
            String errorMessage = stringBuffer.toString();
            logger.error(errorMessage);
            throw new ResourceRegistryException(errorMessage);
        }
        return true;
    }
}

