/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.uriresolvermanager.resolvers.query;

import java.util.HashMap;
import java.util.Map;
import org.gcube.portlets.user.uriresolvermanager.resolvers.query.CatalogueResolverQueryString;
import org.gcube.portlets.user.uriresolvermanager.util.UrlEncoderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatalogueResolverQueryStringBuilder {
    public static final String DEFAULT_STATUS = "pending";
    public static final String DEFAULT_MODERATION_OP = CatalogueResolverQueryString.MODERATION_OP.show.name();
    public static final Logger LOG = LoggerFactory.getLogger(CatalogueResolverQueryStringBuilder.class);
    public static final String MODERATION_PARAMETER = "moderation";
    public static final String ITEM_NAME_PARAMETER = "item_name";
    public static final String ITEM_ID_PARAMETER = "item_id";
    public static final String STATUS_PARAMETER = "status";
    public static final String QUERY_STRING_PARAMETER = "query_string";
    private final String itemName;
    private String itemId;
    private String itemStatus;
    private CatalogueResolverQueryString.MODERATION_OP moderation;

    public CatalogueResolverQueryStringBuilder(String itemName) {
        this.itemName = itemName;
    }

    public CatalogueResolverQueryStringBuilder itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    public CatalogueResolverQueryStringBuilder moderation(CatalogueResolverQueryString.MODERATION_OP moderation) {
        this.moderation = moderation;
        return this;
    }

    public CatalogueResolverQueryStringBuilder itemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getItemStatus() {
        return this.itemStatus;
    }

    public CatalogueResolverQueryString.MODERATION_OP getModeration() {
        return this.moderation;
    }

    public Map<String, String> buildQueryParameters() {
        CatalogueResolverQueryString crQS = new CatalogueResolverQueryString(this);
        if (crQS.getItemName() == null || crQS.getItemName().isEmpty()) {
            throw new IllegalArgumentException("The item_name cannot be null or empty");
        }
        HashMap<String, String> query = new HashMap<String, String>();
        query.put(ITEM_NAME_PARAMETER, crQS.getItemName());
        if (crQS.getItemId() != null) {
            query.put(ITEM_ID_PARAMETER, crQS.getItemId());
        }
        if (crQS.getItemStatus() != null) {
            query.put(STATUS_PARAMETER, crQS.getItemStatus());
        } else {
            query.put(STATUS_PARAMETER, DEFAULT_STATUS);
        }
        if (crQS.getModeration() != null) {
            query.put(MODERATION_PARAMETER, crQS.getModeration().name());
        } else {
            query.put(MODERATION_PARAMETER, DEFAULT_MODERATION_OP);
        }
        return query;
    }

    public String buildQueryParametersToQueryString() {
        Map<String, String> mapParameters = this.buildQueryParameters();
        return UrlEncoderUtil.toQueryString(mapParameters);
    }

    public CatalogueResolverQueryString buildQueryObj() {
        return new CatalogueResolverQueryString(this);
    }
}

