/**
 * 
 */
package org.gcube.portlets.user.uriresolvermanager.entity;

/**
 * @author Francesco Mangiacrapa (francesco.mangiacrapa@isti.cnr.it)
 * Oct 14, 2014
 *
 */
public class ServiceParameter {
	
	private String key;
	private String defaultValue;
	private boolean isMandatory;
	
	
	/**
	 * Constructor for ServiceParameter.
	 * @param key the key of the parameter
	 * @param value the default value of the parameter
	 * @param isMandatory true if the parameter is mandatory, false otherwise
	 */
	public ServiceParameter(String key, String value, boolean isMandatory) {
		super();
		this.key = key;
		this.isMandatory = isMandatory;
	}

		
	
	/**
	 * Constructor for ServiceParameter.
	 * @param key the key of the parameter
	 * @param isMandatory true if the parameter is mandatory, false otherwise
	 */
	public ServiceParameter(String key, boolean isMandatory) {
		super();
		this.key = key;
		this.isMandatory = isMandatory;
	}
	
	/**
	 * Gets the key of the parameter.
	 * @return the key of the parameter
	 */
	public String getKey() {
		return key;
	}
	
	/**
	 * Gets the default value of the parameter.
	 * @return the default value of the parameter
	 */
	public String getDefaultValue() {
		return defaultValue;
	}
	
	/**
	 * Checks if the parameter is mandatory.
	 * @return true if the parameter is mandatory, false otherwise
	 */
	public boolean isMandatory() {
		return isMandatory;
	}
	
	/**
	 * Sets the key of the parameter.
	 * @param key the key to set
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * Sets the default value of the parameter.
	 * @param defaultValue the default value to set
	 */
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}
	
	/**
	 * Sets whether the parameter is mandatory.
	 * @param isMandatory true if the parameter is mandatory, false otherwise
	 */
	public void setMandatory(boolean isMandatory) {
		this.isMandatory = isMandatory;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ServiceProperty [key=");
		builder.append(key);
		builder.append(", defaultValue=");
		builder.append(defaultValue);
		builder.append(", isMandatory=");
		builder.append(isMandatory);
		builder.append("]");
		return builder.toString();
	}
	
}
