/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.ConfigurationFacetImpl;

/**
 * It does not define any properties.
 * It is mainly used to store one or more arbitrary properties attached to a
 * Configuration resource.
 * Before using ConfigurationFacet, a developer should evaluate if it is
 * possible to identify a specific Facet to capture the particular aspect of the
 * resource.
 * It should not be used to store information which is available in other
 * resources that should be related to the Configuration resource.
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as = ConfigurationFacetImpl.class)
@TypeMetadata(name = ConfigurationFacet.NAME, description = "It does not define any properties. "
		+ "It is mainly used to store one or more arbitrary properties attached to a Configuration resource. "
		+ "Before using ConfigurationFacet, a developer should evaluate if it is possible to identify a specific Facet "
		+ "to capture the particular aspect of the resource. "
		+ "It should not be used to store information which is available in other resources that should be related to the Configuration resource.", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface ConfigurationFacet extends Facet {

	/** The name associated with this facet */
	public static final String NAME = "ConfigurationFacet"; // ConfigurationFacet.class.getSimpleName();

}