/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.reference.properties.utilities.Named;

/**
 * SoftwareFacet captures information on any software associated with the
 * resource.
 * 
 * https://wiki.gcube-system.org/gcube/GCube_Model#Software_Facet
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as = SoftwareFacetImpl.class)
@TypeMetadata(name = SoftwareFacet.NAME, description = "SoftwareFacet captures information on any software associated with the resource.", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface SoftwareFacet extends Facet, Named {

	/** The name associated with this facet */
	public static final String NAME = "SoftwareFacet"; // SoftwareFacet.class.getSimpleName();

	/** The name of 'group' property */
	public static final String GROUP_PROPERTY = "group";
	/** The name of 'version' property */
	public static final String VERSION_PROPERTY = "version";

	/** The name of 'description' property */
	public static final String DESCRIPTION_PROPERTY = "description";
	/** The name of 'qualifier' property */
	public static final String QUALIFIER_PROPERTY = "qualifier";
	/** The name of 'optional' property */
	public static final String OPTIONAL_PROPERTY = "optional";

	/**
	 * The name of the software artifact being described, e.g., artifactId in
	 * maven coordinates, the software name for retail software such as 'Office'
	 * (in Microsoft™ Office 2013-SP2)
	 * @return the name
	 */
	@Override
	@ISProperty(name = NAME_PROPERTY, description = "The name of the software artifact being described, "
			+ "e.g., artifactId in maven coordinates, the software name for retail software "
			+ "such as 'Office' (in Microsoft™ Office 2013-SP2)", mandatory = true, nullable = false)
	public String getName();

	/**
	 * Sets the name of the software artifact being described, e.g., artifactId
	 * in maven coordinates, the software name for retail software such as
	 * 'Office' (in Microsoft™ Office 2013-SP2)
	 * @param name the name
	 */	
	@Override
	public void setName(String name);

	/**
	 * The name of 'group' the software artifact belongs to, e.g., groupId in
	 * maven coordinates, company name for retail software software such as
	 * 'Microsoft™' (in Microsoft™ Office 2013-SP2)	
	 * @return the group
	 */
	@ISProperty(name = GROUP_PROPERTY, description = "The name of 'group' the software artifact belongs to, "
			+ "e.g., groupId in maven coordinates, company name for retail software software "
			+ "such as 'Microsoft™' (in Microsoft™ Office 2013-SP2)", mandatory = true, nullable = false)
	public String getGroup();

	/**
	 * Sets the name of 'group' the software artifact belongs to, e.g., groupId
	 * in maven coordinates, company name for retail software software such as
	 * 'Microsoft™' (in Microsoft™ Office 2013-SP2)
	 * @param group the group
	 */
	public void setGroup(String group);

	/**
	 * The particular release of the software artifact, e.g., version in maven
	 * coordinates, the software version for retail software such as '2013-SP2'
	 * (in Microsoft™ Office 2013-SP2)
	 * @return the version
	 */
	@ISProperty(name = VERSION_PROPERTY, description = "The particular release of the software artifact, "
			+ "e.g., version in maven coordinates, the software version for retail software "
			+ "such as '2013-SP2' (in Microsoft™ Office 2013-SP2)", mandatory = true, nullable = false)
	public String getVersion();

	/**
	 * Sets the particular release of the software artifact, e.g., version in maven
	 * coordinates, the software version for retail software such as '2013-SP2'
	 * (in Microsoft™ Office 2013-SP2)
	 * @param version the version
	 */
	public void setVersion(String version);

	/**
	 * A human oriented description of the software artifact being described
	 * @return the description
	 */
	@ISProperty(name = DESCRIPTION_PROPERTY, description = "A human oriented description of the software artifact being described")
	public String getDescription();

	/**
	 * Sets a human oriented description of the software artifact being described
	 * @param description the description
	 */
	public void setDescription(String description);

	/**
	 * A qualifier for the software, e.g., packaging or scope in maven
	 * coordinates, target architecture for retail software such as x86 or amd64
	 * @return the qualifier
	 */
	@ISProperty(name = QUALIFIER_PROPERTY, description = "A qualifier for the software, "
			+ "e.g., packaging or scope in maven coordinates, "
			+ "target architecture for retail software such as x86 or amd64")
	public String getQualifier();

	/**
	 * Sets a qualifier for the software, e.g., packaging or scope in maven
	 * coordinates, target architecture for retail software such as x86 or amd64
	 * @param qualifier the qualifier
	 */
	public void setQualifier(String qualifier);

	/**
	 * Used to indicate the software optionality, e.g., optional in maven
	 * coordinates
	 * @return true if the software is optional
	 */
	@ISProperty(name = OPTIONAL_PROPERTY, description = "Used to indicate the software optionality,"
			+ " e.g., optional in maven coordinates")
	public boolean isOptional();

	/**
	 * Sets the software optionality, e.g., optional in maven coordinates
	 * @param optional true if the software is optional
	 */
	public void setOptional(boolean optional);

}
