package org.gcube.resourcemanagement.model.reference.properties;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.properties.AccessPolicyImpl;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=AccessPolicyImpl.class)
@TypeMetadata(
	name = AccessPolicy.NAME, 
	description = "AccessPolicy information",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface AccessPolicy extends GCubeProperty {
	
	/** The name associated with this property */
	public static final String NAME = "AccessPolicy"; //AccessPolicy.class.getSimpleName();
	
	/**
	 * Returns a default instance of AccessPolicy
	 * @return a default instance of AccessPolicy
	 */
	public static AccessPolicy getDefaultInstance() {
		return new AccessPolicyImpl();
	}

	/**
	 * The access policy
	 * @return
	 */
	@ISProperty
	public ValueSchema getPolicy();

	/**
	 * Sets the access policy
	 * @param policy
	 */
	public void setPolicy(ValueSchema policy);
	
	/**
	 * A note associated with the access policy
	 * @return the note
	 */
	@ISProperty
	public String getNote();
	
	/**
	 * Sets a note associated with the access policy
	 * @param note the note
	 */
	public void setNote(String note);
}
