/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.reference.properties.utilities.Named;

@JsonDeserialize(as=SoftwareFacetImpl.class)
@TypeMetadata(name="SoftwareFacet", description="SoftwareFacet captures information on any software associated with the resource.", version="1.0.0")
@Change(version="1.0.0", description="First Version")
public interface SoftwareFacet
extends Facet,
Named {
    public static final String NAME = "SoftwareFacet";
    public static final String GROUP_PROPERTY = "group";
    public static final String VERSION_PROPERTY = "version";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String QUALIFIER_PROPERTY = "qualifier";
    public static final String OPTIONAL_PROPERTY = "optional";

    public static SoftwareFacet getDefaultInstance() {
        return new SoftwareFacetImpl();
    }

    @Override
    @ISProperty(name="name", description="The name of the software artifact being described, e.g., artifactId in maven coordinates, the software name for retail software such as 'Office' (in Microsoft\u2122 Office 2013-SP2)", mandatory=true, nullable=false)
    public String getName();

    @Override
    public void setName(String var1);

    @ISProperty(name="group", description="The name of 'group' the software artifact belongs to, e.g., groupId in maven coordinates, company name for retail software software such as 'Microsoft\u2122' (in Microsoft\u2122 Office 2013-SP2)", mandatory=true, nullable=false)
    public String getGroup();

    public void setGroup(String var1);

    @ISProperty(name="version", description="The particular release of the software artifact, e.g., version in maven coordinates, the software version for retail software such as '2013-SP2' (in Microsoft\u2122 Office 2013-SP2)", mandatory=true, nullable=false)
    public String getVersion();

    public void setVersion(String var1);

    @ISProperty(name="description", description="A human oriented description of the software artifact being described")
    public String getDescription();

    public void setDescription(String var1);

    @ISProperty(name="qualifier", description="A qualifier for the software, e.g., packaging or scope in maven coordinates, target architecture for retail software such as x86 or amd64")
    public String getQualifier();

    public void setQualifier(String var1);

    @ISProperty(name="optional", description="Used to indicate the software optionality, e.g., optional in maven coordinates")
    public boolean isOptional();

    public void setOptional(boolean var1);
}

