/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;
import java.net.URL;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ContactReferenceFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=ContactReferenceFacet.NAME)
public class ContactReferenceFacetImpl extends FacetImpl implements ContactReferenceFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = 286704827655240356L;

	protected URL website;
	protected String address;
	protected String phoneNumber;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public URL getWebsite() {
		return this.website;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setWebsite(URL website) {
		this.website = website;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getAddress() {
		return this.address;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAddress(String address) {
		this.address = address;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getPhoneNumber() {
		return this.phoneNumber;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setPhoneNumber(String phoneNumber) {
		this.phoneNumber = phoneNumber;
	}

}
