package org.gcube.resourcemanagement.model.reference.properties.utilities;

/**
 * @author Manuele Simi (ISTI - CNR)
 */
public interface TypedProperty<T, V> {
	
	/**
	 * Gets the value of the property.
	 * @return the value
	 */
	public V getValue();
	
	/**
	 * Sets the value of the property.
	 * @param value the new value
	 */
	public void setValue(V value);
	
	/**
	 * Gets the schema of the property.
	 * @return the schema
	 */
	public T getSchema();
	
	/**
	 * Sets the schema of the property.
	 * @param type the new schema
	 */
	public void setSchema(T type);
	
}
