/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.properties;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.types.PropertyTypeName;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.utils.AttributeUtility;
import org.gcube.resourcemanagement.model.reference.properties.AttributeProperty;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=AttributeProperty.NAME)
public class AttributePropertyImpl extends GCubePropertyImpl implements AttributeProperty {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -3706392922894176884L;
	
	protected String name;
	protected String description;
	private boolean mandatory = false;
	private boolean notnull = false;
	private Integer max= null;
	private Integer min= null;
	private String regexp= null;
	private PropertyTypeName propertyTypeName = null; 
	protected Object defaultValue;
	
	/**
	 * Default constructor
	 */
	public AttributePropertyImpl() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDescription() {
		return description;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isMandatory() {
		return mandatory;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMandatory(boolean mandatory) {
		this.mandatory = mandatory;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isNotnull() {
		return notnull;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setNotnull(boolean notnull) {
		this.notnull = notnull;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getMax() {
		return max;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMax(Integer max) {
		this.max = max;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getMin() {
		return min;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMin(Integer min) {
		this.min = min;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getRegexp() {
		return regexp;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRegexp(String regexp) {
		AttributeUtility.checkRegex(regexp, null);
		this.regexp = regexp;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getPropertyType() {
		return propertyTypeName.toString();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	@JsonSetter(value = PropertyDefinition.PROPERTY_TYPE_PROPERTY)
	public void setPropertyType(String type) {
		this.propertyTypeName = new PropertyTypeName(type);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	@JsonIgnore
	public PropertyTypeName getPropertyTypeName() {
		return propertyTypeName;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getDefaultValue() {
		return defaultValue;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDefaultValue(Object defaultValue) {
		this.defaultValue = defaultValue;
	}
	
}
