/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.informationsystem.model.reference.properties.Event;
import org.gcube.resourcemanagement.model.reference.entities.facets.EventFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = EventFacet.NAME)
public class EventFacetImpl extends FacetImpl implements EventFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = -4130548762073254058L;

	protected Event event;

	/**
	 * {@inheritDoc}
	 */
	@Override
	@JsonGetter(EventFacet.EVENT_PROPERTY)
	public Event getEvent() {
		return event;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	@JsonSetter(EventFacet.EVENT_PROPERTY)
	public void setEvent(Event event) {
		this.event = event;
	}

}