/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;
import java.net.URI;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.resourcemanagement.model.reference.entities.facets.AccessPointFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=AccessPointFacet.NAME)
public class AccessPointFacetImpl extends FacetImpl implements AccessPointFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = -2780577881844464254L;
	
	/** 
	 * The name of the access point entry
	 */
	protected String entryName;
	
	/** 
	 * The endpoint URI of the access point
	 */
	protected URI endpoint;
	
	/** 
	 * The protocol used by the access point
	 */
	protected String protocol;
	
	/** 
	 * A description of the access point
	 */
	protected String description;
	
	/** 
	 * Authorization information for the access point
	 */
	protected Property authorization;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getEntryName() {
		return this.entryName;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setEntryName(String entryName) {
		this.entryName = entryName;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public URI getEndpoint() {
		return this.endpoint;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setEndpoint(URI endpoint) {
		this.endpoint = endpoint;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getProtocol() {
		return this.protocol;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDescription() {
		return this.description;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Property getAuthorization() {
		return this.authorization;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setAuthorization(Property authorization) {
		this.authorization = authorization;
	}

}
