/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ContactFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=ContactFacet.NAME)
public class ContactFacetImpl extends FacetImpl implements ContactFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = -4036703255922676717L;
	
	protected String id;
	protected String title;
	protected String name;
	protected String middleName;
	protected String surname;
	protected String eMail;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getId() {
		return this.id;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getTitle() {
		return this.title;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return this.name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getMiddleName() {
		return this.middleName;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getSurname() {
		return this.surname;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSurname(String surname) {
		this.surname = surname;
	}

	/**
	 * {@inheritDoc}
	 */
	@JsonProperty(EMAIL_PROPERTY)
	@Override
	public String getEMail() {
		return this.eMail;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setEMail(String eMail) {
		this.eMail = eMail;
	}

}
