package org.gcube.resourcemanagement.model.impl.relations.consistsof;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.resourcemanagement.model.reference.entities.facets.ContactFacet;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasManager;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = HasManager.NAME)
public class HasManagerImpl<Out extends Resource, In extends ContactFacet>
		extends HasContactImpl<Out, In> implements HasManager<Out, In> {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -7136048435035542411L;

	/*
	 * Protected default constructor
	 */
	protected HasManagerImpl() {
		super();
	}

	/**
	 * Creates an instance of HasManager
	 * @param source the source Resource
	 * @param target the target ContactFacet
	 */
	public HasManagerImpl(Out source, In target) {
		super(source, target);
	}
	
	/**
	 * Creates an instance of HasManager
	 * @param source the source Resource
	 * @param target the target ContactFacet
	 * @param propagationConstraint the Propagation Constraint
	 */
	public HasManagerImpl(Out source, In target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
	}

}
