package org.gcube.resourcemanagement.model.impl.relations.consistsof;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.resourcemanagement.model.reference.entities.facets.ActionFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasAddAction;

/**
 * An implementation of the {@link HasAddAction} relation.
 * 
 * @author Manuele Simi (ISTI CNR)
 *
 */
@JsonTypeName(value = HasAddAction.NAME)
public class HasAddActionImpl<Out extends Service, In extends ActionFacet>
	extends HasActionImpl<Out, In> implements HasAddAction<Out, In>{

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -1255378439187531889L;

	/**
	 * Protected default constructor
	 */
	protected HasAddActionImpl() {
		super();
	}
	
	/**
	 * Creates an instance of HasAddAction
	 * @param source the source Service
	 * @param target the target ActionFacet
	 */
	public HasAddActionImpl(Out source, In target) {
		super(source, target);
	}
	
	/**
	 * Creates an instance of HasAddAction
	 * @param source the source Service
	 * @param target the target ActionFacet
	 * @param propagationConstraint the Propagation Constraint
	 */
	public HasAddActionImpl(Out source, In target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
	}
}
