/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.IdentifierFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=IdentifierFacet.NAME)
public class IdentifierFacetImpl extends FacetImpl implements IdentifierFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = 5711870008624673728L;

	/** 
	 * The identifier value
	 */
	protected String value;
	
	/** 
	 * The identification type
	 */
	protected IdentificationType type;
	
	/** 
	 * Whether the identifier is persistent
	 */
	protected boolean persistent;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getValue() {
		return value;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public IdentificationType getIdentificationType() {
		return type;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setIdentificationType(IdentificationType type) {
		this.type = type;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isPersistent() {
		return persistent;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setPersistent(boolean persistent) {
		this.persistent = persistent;
	}

}
