/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.CapabilityFacetImpl;

/**
 * CapabilityFacet captures a defined facility to perform a specified task supported by a given Resource.
 * It is mainly used to provide a human-readable description of the capabilities of a resource
 * (e.g., the support for transactions of an electronic device or some non-functional 
 * properties of a service like its replicability to support High-Availability (HA)).
 * 
 * https://wiki.gcube-system.org/gcube/GCube_Model#Capability_Facet
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=CapabilityFacetImpl.class)
@TypeMetadata(
	name = CapabilityFacet.NAME, 
	description = "CapabilityFacet captures a defined facility for performing a specified task supported by a given Resource. "
			+ "It is mainly used to provide a human-readable description of the capabilities of a resource "
			+ "(e.g., the support for transactions of an electronic device or some non-functional "
			+ "properties of a service like its replicability to support High-Availability (HA)).",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface CapabilityFacet extends Facet {

	/** The name associated with this facet */
	public static final String NAME = "CapabilityFacet"; // CapabilityFacet.class.getSimpleName();

	/**
	 * Returns a default instance of CapabilityFacet
	 * @return a default instance of CapabilityFacet
	 */
	public static CapabilityFacet getDefaultInstance() {
		return new CapabilityFacetImpl();
	}

	/**
	 * The distinguishing name of the capability.
	 * @return the name
	 */
	@ISProperty(description = "The distinguishing name of the capability.", mandatory=true, nullable=false)
	public String getName();

	/**
	 * Sets the distinguishing name of the capability.
	 * @param name the name
	 */
	public void setName(String name);

	/**
	 * A human oriented description of the capability.
	 * @return the description
	 */
	@ISProperty(description = "A human oriented description of the capability.")
	public String getDescription();

	/**
	 * Sets a human oriented  description of the capability.
	 * @param description the description
	 */
	public void setDescription(String description);

	/**
	 * A string used to specialise the capability.
	 * @return the qualifier
	 */
	@ISProperty(description = "A string used to specialise the capability.")
	public String getQualifier();

	/**
	 * Sets the qualifier of the capability.
	 * @param qualifier the qualifier
	 */
	public void setQualifier(String qualifier);

}
