/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.StateFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=StateFacet.NAME)
public class StateFacetImpl extends FacetImpl implements StateFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = -6149286208701421212L;
	
	/**
	 * The value of the state 
	 */
	protected String value;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getValue() {
		return value;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setValue(String value) {
		this.value = value;
	}

}
