package org.gcube.resourcemanagement.model.impl.relations.consistsof;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.resourcemanagement.model.reference.entities.facets.MemoryFacet;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasVolatileMemory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = HasVolatileMemory.NAME)
public class HasVolatileMemoryImpl<Out extends Resource, In extends MemoryFacet>
		extends HasMemoryImpl<Out, In> implements HasVolatileMemory<Out, In> {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -3419282968469134859L;

	/**
	 * Protected default constructor
	 */
	protected HasVolatileMemoryImpl() {
		super();
	}

	/**
	 * Creates an instance of HasVolatileMemory
	 * @param source the source Resource
	 * @param target the target MemoryFacet
	 */
	public HasVolatileMemoryImpl(Out source, In target) {
		super(source, target);
	}
	
	/**
	 * Creates an instance of HasVolatileMemory
	 * @param source the source Resource
	 * @param target the target MemoryFacet
	 * @param propagationConstraint the Propagation Constraint
	 */
	public HasVolatileMemoryImpl(Out source, In target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
	}
	
}
