/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.relations.isrelatedto;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.IsDerivationOfImpl;
import org.gcube.resourcemanagement.model.reference.entities.resources.Configuration;
import org.gcube.resourcemanagement.model.reference.entities.resources.ConfigurationTemplate;

/**
 * IsDerivationOf indicate that the source {@link Configuration} is an instantiation of
 * the target {@link ConfigurationTemplate}.
 * 
 * https://wiki.gcube-system.org/gcube/GCube_Model#IsDerivationOf
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=IsDerivationOfImpl.class)
@TypeMetadata(
	name = IsDerivationOf.NAME, 
	description = "IsDerivationOf indicate that the source {@link Configuration} is an "
			+ "instantiation of the target {@link ConfigurationTemplate}.",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface IsDerivationOf<Out extends Configuration, In extends ConfigurationTemplate> 
	extends IsRelatedTo<Out, In> {
	
	/** The name of the IsDerivationOf relation type. */
	public static final String NAME = "IsDerivationOf"; // IsDerivationOf.class.getSimpleName();
	
	/**
	 * Returns a default instance of IsDerivationOf
	 * @param <Out> the source Configuration
	 * @param <In> the target ConfigurationTemplate
	 * @param out the source Configuration instance
	 * @param in the target ConfigurationTemplate instance
	 * @return a default instance of IsDerivationOf
	 */
	public static <Out extends Configuration, In extends ConfigurationTemplate> IsDerivationOf<Out, In> getDefaultInstance(Out out, In in) {
		return new IsDerivationOfImpl<Out, In>(out, in);
	}

}