/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.LocationFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=LocationFacet.NAME)
public class LocationFacetImpl extends FacetImpl implements LocationFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = 4041460426127480418L;
	
	/** 
	 * The English name of the country
	 */
	protected String country;

	/** 
	 * The City name
	 */
	protected String location;
	
	/** 
	 * The latitude
	 */
	protected String latitude;
	
	/** 
	 * The longitude
	 */
	protected String longitude;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getCountry() {
		return country;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setCountry(String country) {
		this.country = country;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getLocation() {
		return location;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLocation(String location) {
		this.location = location;
	}
	
	/**
	 * @return the latitude
	 */
	public String getLatitude() {
		return latitude;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getLongitude() {
		return longitude;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}
	
}
