package org.gcube.resourcemanagement.model.reference.properties.utilities;

/**
 * Result of a {@link PropertyValidator}.
 * 
 * @author Manuele Simi (ISTI CNR)
 */
public class Validation {
	
	private final String message;
	private final boolean success;
	
	private Validation(String message, boolean success) {
		this.message = message;
		this.success = success;
	}
	
	/**
	 * Creates a successful validation.
	 * @param message the success message
	 * @return the validation
	 */
	public static Validation success(String message) {
		return new Validation(message, true);
	}
	
	/**
	 * Creates a failed validation.
	 * @param message the failure message
	 * @return the validation
	 */
	public static Validation fail(String message) {
		return new Validation(message, false);
	}
	
	/**
	 * Gets the validation message.
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * Checks if the validation was successful.
	 * @return true if successful, false otherwise
	 */
	public boolean isSuccess() {
		return success;
	}
	
}
