/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.DescriptiveMetadataFacet;
import org.gcube.resourcemanagement.model.reference.properties.ValueSchema;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=DescriptiveMetadataFacet.NAME)
public class DescriptiveMetadataFacetImpl extends FacetImpl implements DescriptiveMetadataFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = -8373583843673756878L;
	
	/**
	 * A metadata record representing the descriptive metadata according to the schema
	 */
	protected ValueSchema descriptiveMetadata;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ValueSchema getDescriptiveMetadata() {
		return descriptiveMetadata;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDescriptiveMetadata(ValueSchema descriptiveMetadata) {
		this.descriptiveMetadata = descriptiveMetadata;
	}
	
}