package org.gcube.resourcemanagement.model.impl.relations.isrelatedto;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.impl.relations.IsRelatedToImpl;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Activates;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = Activates.NAME)
public class ActivatesImpl<Out extends Service, In extends Service> extends
		IsRelatedToImpl<Out, In> implements Activates<Out, In> {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -2770215400873228920L;

	/**
	 * Protected default constructor
	 */
	protected ActivatesImpl() {
		super();
	}

	/**
	 * Creates an instance of Activates
	 * @param source the source Service
	 * @param target the target Service
	 */
	public ActivatesImpl(Out source, In target) {
		super(source, target);
	}
	
	/**
	 * Creates an instance of Activates
	 * @param source the source Service
	 * @param target the target Service
	 * @param propagationConstraint the Propagation Constraint
	 */
	public ActivatesImpl(Out source, In target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
	}

}
