/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement;

import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClient;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClientFactory;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.tree.Node;
import org.gcube.resourcemanagement.internal.model.impl.entities.facets.DiscoveryFacetImpl;
import org.gcube.resourcemanagement.internal.model.reference.entities.facets.DiscoveryFacet;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceManager
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(ResourceManager.class);
    public static boolean initialised = false;

    private static void checkDiscoveryFacetExists() {
        try {
            ResourceRegistrySchemaClient schemaClient = ResourceRegistrySchemaClientFactory.create();
            boolean exists = schemaClient.exist("DiscoveryFacet");
            if (exists) {
                logger.info("DiscoveryFacet type is available in the Resource Registry");
                ResourceManager.checkDiscoveryFacetInClasspath((ResourceRegistrySchemaClient)schemaClient);
            } else {
                logger.warn("DiscoveryFacet type is NOT available in the Resource Registry, going to add it");
                ResourceManager.createDiscoveryFacetInResourceRegistry((ResourceRegistrySchemaClient)schemaClient);
            }
        }
        catch (ResourceRegistryException e) {
            logger.error("Error checking DiscoveryFacet type in Resource Registry", (Throwable)e);
            throw new RuntimeException("Failed to initialize Resource Manager: DiscoveryFacet check failed", e);
        }
        catch (Exception e) {
            logger.error("Unexpected error checking DiscoveryFacet type", (Throwable)e);
            throw new RuntimeException("Failed to initialize Resource Manager: Unexpected error during DiscoveryFacet check", e);
        }
    }

    private static void checkDiscoveryFacetInClasspath(ResourceRegistrySchemaClient schemaClient) {
        try {
            boolean foundInModel = false;
            try {
                Node discoveryFacetNode = schemaClient.getTypeTreeNode("DiscoveryFacet");
                boolean bl = foundInModel = discoveryFacetNode != null;
                if (foundInModel) {
                    logger.info("DiscoveryFacet implementation found in Information System Model tree");
                }
            }
            catch (Exception e) {
                logger.debug("DiscoveryFacet not found in Information System Model tree", (Throwable)e);
            }
            if (foundInModel) {
                logger.info("DiscoveryFacet implementation is available in the classpath and model");
            } else {
                logger.info("DiscoveryFacet implementation is NOT available in the classpath model, registering internal implementation");
                ResourceManager.addDiscoveryFacetToElementMapper();
            }
        }
        catch (Exception e) {
            logger.error("Error checking DiscoveryFacet in classpath and model tree", (Throwable)e);
            try {
                ResourceManager.addDiscoveryFacetToElementMapper();
            }
            catch (Exception fallbackException) {
                logger.error("Failed to register DiscoveryFacet implementation as fallback", (Throwable)fallbackException);
            }
        }
    }

    private static void addDiscoveryFacetToElementMapper() {
        try {
            logger.debug("Registering DiscoveryFacet implementation in ElementMapper");
            ElementMapper.addDynamicAssociation(DiscoveryFacet.class, DiscoveryFacetImpl.class);
            logger.info("Resource Manager DiscoveryFacet implementation has been successfully registered in ElementMapper");
        }
        catch (Exception e) {
            logger.error("Failed to register DiscoveryFacet implementation in ElementMapper", (Throwable)e);
            throw new RuntimeException("Failed to register DiscoveryFacet implementation", e);
        }
    }

    private static void createDiscoveryFacetInResourceRegistry(ResourceRegistrySchemaClient schemaClient) throws SchemaException, ResourceRegistryException {
        try {
            logger.info("Creating DiscoveryFacet type in Resource Registry");
            schemaClient.create(DiscoveryFacet.class);
            logger.info("DiscoveryFacet type has been successfully created in Resource Registry");
            ResourceManager.addDiscoveryFacetToElementMapper();
            logger.info("DiscoveryFacet setup completed: type created in Resource Registry and implementation registered in ElementMapper");
        }
        catch (ResourceRegistryException e) {
            logger.error("Failed to create DiscoveryFacet in Resource Registry", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Unexpected error creating DiscoveryFacet in Resource Registry", (Throwable)e);
            throw new ResourceRegistryException("Unexpected error creating DiscoveryFacet", (Throwable)e);
        }
    }

    public synchronized void onInit() {
        if (ContextProvider.get().container().configuration().mode() == Mode.offline) {
            logger.debug("Init called in offline mode");
            return;
        }
        String context = SecretManagerProvider.get().getContext();
        logger.trace("\n-------------------------------------------------------\nResource Manager is Starting on context {}\n-------------------------------------------------------", (Object)context);
        ApplicationContext applicationContext = ContextProvider.get();
        String rmEServiceID = applicationContext.id();
        logger.info("Resource Manager has the following ID {}", (Object)rmEServiceID);
        logger.trace("\n-------------------------------------------------------\nResource Manager Started Successfully on context {}\n-------------------------------------------------------", (Object)context);
    }

    public synchronized void onShutdown() {
        if (ContextProvider.get().container().configuration().mode() == Mode.offline) {
            logger.debug("Init called in offline mode");
            return;
        }
        String context = SecretManagerProvider.get().getContext();
        logger.trace("\n-------------------------------------------------------\nResource Manager is Stopping on context {}\n-------------------------------------------------------", (Object)context);
        logger.trace("\n-------------------------------------------------------\nResource Manager Stopped Successfully on context {}\n-------------------------------------------------------", (Object)context);
    }

    static {
        logger.info("Resource Manager is being initialized");
        ResourceManager.checkDiscoveryFacetExists();
    }
}

