/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.rest.vremodelling;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ResourceRegistryContextClient;
import org.gcube.informationsystem.resourceregistry.contexts.ResourceRegistryContextClientFactory;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.resourcemanagement.rest.BaseREST;

@Path(value="contexts")
public class ContextManager
extends BaseREST {
    public static final String CONTEXTS_PATH_PART = "contexts";
    public static final String CONTEXT_UUID_PATH_PARAMETER = "CONTEXT_UUID";
    public static final String CURRENT_CONTEXT_PATH_PART = "CURRENT_CONTEXT";

    @POST
    @Path(value="{CONTEXT_UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String create(String json) throws ResourceRegistryException, WebApplicationException {
        this.logger.info("Requested to update/create {} with json {} ", (Object)"Context", (Object)json);
        this.setAccountingMethod("Create Context");
        ResourceRegistryContextClient rrcc = ResourceRegistryContextClientFactory.create();
        return rrcc.create(json);
    }

    @GET
    @Path(value="{CONTEXT_UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="CONTEXT_UUID") String uuid) throws ResourceRegistryException, WebApplicationException {
        ResourceRegistryContextClient rrcc = ResourceRegistryContextClientFactory.create();
        if (uuid.compareTo(CURRENT_CONTEXT_PATH_PART) == 0) {
            this.logger.info("Requested to read current {}", (Object)"Context");
            Context c = rrcc.readCurrentContext();
            try {
                return ElementMapper.marshal((Element)c);
            }
            catch (Exception e) {
                uuid = c.getID().toString();
            }
        }
        this.logger.info("Requested to read {} with id {} ", (Object)"Context", (Object)uuid);
        this.setAccountingMethod("Read Context");
        return rrcc.read(uuid);
    }

    @PUT
    @Path(value="{CONTEXT_UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@PathParam(value="CONTEXT_UUID") String uuid, String json) throws ResourceRegistryException, WebApplicationException {
        this.logger.info("Requested to update/create {} with UUID {}\u00a0- Json {} ", new Object[]{"Context", uuid, json});
        this.setAccountingMethod("Update Context");
        ResourceRegistryContextClient rrcc = ResourceRegistryContextClientFactory.create();
        try {
            Context c = (Context)ElementMapper.unmarshal(Context.class, (String)json);
            if (c.getID().toString().compareTo(uuid) != 0) {
                throw new BadRequestException("UUID provide as path parameter does not match with the ID of represented Context");
            }
        }
        catch (IOException e) {
            throw new BadRequestException("The Json representation of the context you provided is invalid");
        }
        return rrcc.update(json);
    }

    @DELETE
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Path(value="{CONTEXT_UUID}")
    public Response delete(@PathParam(value="CONTEXT_UUID") String uuid) throws ResourceRegistryException, WebApplicationException {
        this.logger.info("Requested to delete {} with id {} ", (Object)"Context", (Object)uuid);
        this.setAccountingMethod("Delete Context");
        ResourceRegistryContextClient rrcc = ResourceRegistryContextClientFactory.create();
        rrcc.delete(uuid);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

