/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.config;

import java.util.HashMap;
import java.util.Map;
import org.gcube.common.clients.config.Property;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyPlugin;

public abstract class AbstractConfig<A, S>
implements ProxyConfig<A, S> {
    private final ProxyPlugin<A, S, ?> plugin;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    protected AbstractConfig(ProxyPlugin<A, S, ?> plugin) {
        this.plugin = plugin;
    }

    @Override
    public ProxyPlugin<A, S, ?> plugin() {
        return this.plugin;
    }

    @Override
    public long timeout() throws IllegalArgumentException {
        if (!this.hasProperty("timeout")) {
            throw new IllegalArgumentException("timeout property is undefined");
        }
        return this.property("timeout", Long.class);
    }

    @Override
    public <T> void addProperty(String name, T value) {
        this.properties.put(name, value);
    }

    @Override
    public void addProperty(Property<?> property) {
        this.properties.put(property.name(), property.value());
    }

    @Override
    public boolean hasProperty(String property) {
        return this.properties.containsKey(property);
    }

    @Override
    public <T> T property(String property, Class<T> clazz) throws IllegalStateException, IllegalArgumentException {
        if (!this.hasProperty(property)) {
            throw new IllegalStateException(property + " is unknown");
        }
        try {
            return clazz.cast(this.properties.get(property));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not retrieve " + property + " as " + String.valueOf(clazz), e);
        }
    }
}

