/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.databook.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.internet.AddressException;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Attachment;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteOperationResult;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portal.databook.shared.Post;
import org.gcube.portal.databook.shared.PostType;
import org.gcube.portal.databook.shared.RangeFeeds;
import org.gcube.portal.databook.shared.RangePosts;
import org.gcube.portal.databook.shared.ex.ColumnNameNotFoundException;
import org.gcube.portal.databook.shared.ex.CommentIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.InviteIDNotFoundException;
import org.gcube.portal.databook.shared.ex.InviteStatusNotFoundException;
import org.gcube.portal.databook.shared.ex.LikeIDNotFoundException;
import org.gcube.portal.databook.shared.ex.NotificationChannelTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.NotificationIDNotFoundException;
import org.gcube.portal.databook.shared.ex.NotificationTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.PrivacyLevelTypeNotFoundException;
import org.gcube.social_networking.social_networking_client_library.LibClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBCassandraAstyanaxImpl
implements DatabookStore {
    private static final Logger _log = LoggerFactory.getLogger(DBCassandraAstyanaxImpl.class);
    private static LibClient libClient;

    protected DBCassandraAstyanaxImpl(boolean dropSchema) {
        try {
            libClient = new LibClient();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DBCassandraAstyanaxImpl() {
        try {
            libClient = new LibClient();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DBCassandraAstyanaxImpl(String infrastructureName) {
        try {
            libClient = new LibClient();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean requestFriendship(String from, String to) {
        return true;
    }

    @Override
    public boolean approveFriendship(String from, String to) {
        return true;
    }

    @Override
    public boolean denyFriendship(String from, String to) {
        return true;
    }

    @Override
    public List<String> getFriends(String userid) {
        ArrayList<String> toReturn = new ArrayList<String>();
        return toReturn;
    }

    @Override
    public List<String> getPendingFriendRequests(String userid) {
        ArrayList<String> toReturn = new ArrayList<String>();
        return toReturn;
    }

    private static Post feed2post(Feed feed) {
        Post post = new Post();
        if (feed.getKey() != null) {
            post.setKey(feed.getKey());
        }
        if (feed.getType() != null) {
            post.setType(PostType.valueOf((String)feed.getType().toString()));
        }
        if (feed.getEntityId() != null) {
            post.setEntityId(feed.getEntityId());
        }
        if (feed.getTime() != null) {
            post.setTime(feed.getTime());
        }
        if (feed.getVreid() != null) {
            post.setVreid(feed.getVreid());
        }
        if (feed.getUri() != null) {
            post.setUri(feed.getUri());
        }
        if (feed.getUriThumbnail() != null) {
            post.setUriThumbnail(feed.getUriThumbnail());
        }
        if (feed.getDescription() != null) {
            post.setDescription(feed.getDescription());
        }
        if (feed.getPrivacy() != null) {
            post.setPrivacy(feed.getPrivacy());
        }
        if (feed.getFullName() != null) {
            post.setFullName(feed.getFullName());
        }
        if (feed.getEmail() != null) {
            post.setEmail(feed.getEmail());
        }
        if (feed.getThumbnailURL() != null) {
            post.setThumbnailURL(feed.getThumbnailURL());
        }
        if (feed.getCommentsNo() != null) {
            post.setCommentsNo(feed.getCommentsNo());
        }
        if (feed.getLikesNo() != null) {
            post.setLikesNo(feed.getLikesNo());
        }
        if (feed.getLinkTitle() != null) {
            post.setLinkTitle(feed.getLinkTitle());
        }
        if (feed.getLinkDescription() != null) {
            post.setLinkDescription(feed.getLinkDescription());
        }
        if (feed.getLinkHost() != null) {
            post.setLinkHost(feed.getLinkHost());
        }
        post.setApplicationFeed(feed.isApplicationFeed());
        post.setMultiFileUpload(feed.isMultiFileUpload());
        return post;
    }

    private static Feed post2feed(Post post) {
        Feed feed = new Feed();
        if (post.getKey() != null) {
            feed.setKey(post.getKey());
        }
        if (post.getType() != null) {
            feed.setType(FeedType.valueOf((String)post.getType().toString()));
        }
        if (post.getEntityId() != null) {
            feed.setEntityId(post.getEntityId());
        }
        if (post.getTime() != null) {
            feed.setTime(post.getTime());
        }
        if (post.getVreid() != null) {
            feed.setVreid(post.getVreid());
        }
        if (post.getUri() != null) {
            feed.setUri(post.getUri());
        }
        if (post.getUriThumbnail() != null) {
            feed.setUriThumbnail(post.getUriThumbnail());
        }
        if (post.getDescription() != null) {
            feed.setDescription(post.getDescription());
        }
        if (post.getPrivacy() != null) {
            feed.setPrivacy(post.getPrivacy());
        }
        if (post.getFullName() != null) {
            feed.setFullName(post.getFullName());
        }
        if (post.getEmail() != null) {
            feed.setEmail(post.getEmail());
        }
        if (post.getThumbnailURL() != null) {
            feed.setThumbnailURL(post.getThumbnailURL());
        }
        if (post.getCommentsNo() != null) {
            feed.setCommentsNo(post.getCommentsNo());
        }
        if (post.getLikesNo() != null) {
            feed.setLikesNo(post.getLikesNo());
        }
        if (post.getLinkTitle() != null) {
            feed.setLinkTitle(post.getLinkTitle());
        }
        if (post.getLinkDescription() != null) {
            feed.setLinkDescription(post.getLinkDescription());
        }
        if (post.getLinkHost() != null) {
            feed.setLinkHost(post.getLinkHost());
        }
        feed.setApplicationFeed(post.isApplicationFeed());
        feed.setMultiFileUpload(post.isMultiFileUpload());
        return feed;
    }

    @Override
    @Deprecated
    public boolean saveUserFeed(Feed post) {
        return this.saveUserPost(DBCassandraAstyanaxImpl.feed2post(post));
    }

    @Override
    public boolean saveUserPost(Post post) {
        return libClient.saveUserPostLib(post);
    }

    @Override
    @Deprecated
    public boolean saveUserFeed(Feed feed, List<Attachment> attachments) {
        return this.saveUserPost(DBCassandraAstyanaxImpl.feed2post(feed), attachments);
    }

    @Override
    public boolean saveUserPost(Post post, List<Attachment> attachments) {
        return libClient.saveUserPostLib(post, attachments);
    }

    @Override
    @Deprecated
    public boolean saveAppFeed(Feed post) {
        return this.saveAppPost(DBCassandraAstyanaxImpl.feed2post(post));
    }

    @Override
    public boolean saveAppPost(Post post) {
        return libClient.saveAppPostLib(post);
    }

    @Override
    @Deprecated
    public boolean saveAppFeed(Feed feed, List<Attachment> attachments) {
        return this.saveAppPost(DBCassandraAstyanaxImpl.feed2post(feed), attachments);
    }

    @Override
    public boolean saveAppPost(Post post, List<Attachment> attachments) {
        return libClient.saveAppPostLib(post, attachments);
    }

    @Override
    @Deprecated
    public boolean saveFeedToVRETimeline(String feedKey, String vreid) throws FeedIDNotFoundException {
        return this.savePostToVRETimeline(feedKey, vreid);
    }

    @Override
    public boolean savePostToVRETimeline(String postKey, String vreid) throws FeedIDNotFoundException {
        return libClient.savePostToVRETimelineLib(postKey, vreid);
    }

    @Override
    @Deprecated
    public Feed readFeed(String feedid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        return DBCassandraAstyanaxImpl.post2feed(this.readPost(feedid));
    }

    @Override
    public Post readPost(String postid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        return libClient.readPostLib(postid);
    }

    @Override
    @Deprecated
    public List<Feed> getRecentFeedsByUserAndDate(String userid, long timeInMillis) throws IllegalArgumentException {
        Date now = new Date();
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        List<Post> posts = this.getRecentPostsByUserAndDate(userid, timeInMillis);
        if (posts != null) {
            _log.debug("Length of posts is " + posts.size());
            for (Post post : posts) {
                _log.debug(post.toString());
                feeds.add(DBCassandraAstyanaxImpl.post2feed(post));
            }
        }
        return feeds;
    }

    @Override
    public List<Post> getRecentPostsByUserAndDate(String userid, long timeInMillis) throws IllegalArgumentException {
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        return libClient.getRecentPostsByUserAndDateLib(userid, timeInMillis);
    }

    @Override
    @Deprecated
    public boolean deleteFeed(String feedId) throws FeedIDNotFoundException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException {
        return this.deletePost(feedId);
    }

    @Override
    public boolean deletePost(String postid) throws FeedIDNotFoundException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException {
        return libClient.deletePostLib(postid);
    }

    @Override
    @Deprecated
    public List<Feed> getAllFeedsByUser(String userid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        List<Post> posts = this.getAllPostsByUser(userid);
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        if (posts != null) {
            for (Post post : posts) {
                feeds.add(DBCassandraAstyanaxImpl.post2feed(post));
            }
        }
        return feeds;
    }

    @Override
    public List<Post> getAllPostsByUser(String userid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return libClient.getAllPostsByUserLib(userid);
    }

    @Override
    public List<Feed> getAllFeedsByApp(String appid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        List<Post> posts = this.getAllPostsByApp(appid);
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        if (posts != null) {
            for (Post post : posts) {
                feeds.add(DBCassandraAstyanaxImpl.post2feed(post));
            }
        }
        return feeds;
    }

    @Override
    public List<Post> getAllPostsByApp(String appid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return libClient.getAllPostsByAppLib(appid);
    }

    @Override
    @Deprecated
    public List<Feed> getRecentCommentedFeedsByUserAndDate(String userid, long timeInMillis) throws Exception {
        List<Post> posts = this.getRecentCommentedPostsByUserAndDate(userid, timeInMillis);
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        if (posts != null) {
            for (Post post : posts) {
                feeds.add(DBCassandraAstyanaxImpl.post2feed(post));
            }
        }
        return feeds;
    }

    @Override
    public List<Post> getRecentCommentedPostsByUserAndDate(String userid, long timeInMillis) throws Exception {
        return libClient.getRecentCommentedPostsByUserAndDateLib(userid, timeInMillis);
    }

    @Override
    @Deprecated
    public List<Feed> getAllPortalPrivacyLevelFeeds() throws FeedTypeNotFoundException, ColumnNameNotFoundException, PrivacyLevelTypeNotFoundException {
        List<Post> posts = this.getAllPortalPrivacyLevelPosts();
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        if (posts != null) {
            for (Post post : posts) {
                feeds.add(DBCassandraAstyanaxImpl.post2feed(post));
            }
        }
        return feeds;
    }

    @Override
    public List<Post> getAllPortalPrivacyLevelPosts() throws FeedTypeNotFoundException, ColumnNameNotFoundException, PrivacyLevelTypeNotFoundException {
        return libClient.getAllPortalPrivacyLevelPostsLib();
    }

    @Override
    @Deprecated
    public List<Feed> getRecentFeedsByUser(String userid, int quantity) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        List<Post> posts = this.getRecentPostsByUser(userid, quantity);
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        if (posts != null) {
            for (Post post : posts) {
                feeds.add(DBCassandraAstyanaxImpl.post2feed(post));
            }
        }
        return feeds;
    }

    @Override
    public List<Post> getRecentPostsByUser(String userid, int quantity) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return libClient.getRecentPostsByUserLib(userid, quantity);
    }

    @Override
    @Deprecated
    public List<Feed> getAllFeedsByVRE(String vreid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        List<Post> posts = this.getAllPostsByVRE(vreid);
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        if (posts != null) {
            for (Post post : posts) {
                feeds.add(DBCassandraAstyanaxImpl.post2feed(post));
            }
        }
        return feeds;
    }

    @Override
    public List<Post> getAllPostsByVRE(String vreid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return libClient.getAllPostsByVRELib(vreid);
    }

    @Override
    @Deprecated
    public List<Feed> getRecentFeedsByVRE(String vreid, int quantity) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        _log.debug("\n\n in getRecentFeedsByVRE");
        List<Post> posts = this.getRecentPostsByVRE(vreid, quantity);
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        if (posts != null) {
            _log.debug("length of vre posts = " + posts.size());
            for (Post post : posts) {
                feeds.add(DBCassandraAstyanaxImpl.post2feed(post));
            }
        }
        _log.debug("length of vre feeds = " + feeds.size());
        return feeds;
    }

    @Override
    public List<Post> getRecentPostsByVRE(String vreid, int quantity) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        _log.debug("\n\n in getRecentPostsByVRE");
        return libClient.getRecentPostsByVRELib(vreid, quantity);
    }

    @Override
    public RangeFeeds getRecentFeedsByVREAndRange(String vreid, int from, int quantity) throws IllegalArgumentException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        RangePosts rangePosts = this.getRecentPostsByVREAndRange(vreid, from, quantity);
        ArrayList posts = rangePosts.getPosts();
        if (posts != null) {
            ArrayList<Feed> feeds = new ArrayList<Feed>();
            for (Post post : posts) {
                feeds.add(DBCassandraAstyanaxImpl.post2feed(post));
            }
            RangeFeeds rangeFeeds = new RangeFeeds(rangePosts.getLastReturnedPostTimelineIndex(), feeds);
            return rangeFeeds;
        }
        return new RangeFeeds();
    }

    @Override
    public RangePosts getRecentPostsByVREAndRange(String vreid, int from, int quantity) throws IllegalArgumentException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return libClient.getRecentPostsByVREAndRangeLib(vreid, from, quantity);
    }

    @Override
    public boolean saveNotification(Notification n) {
        return libClient.saveNotificationLib(n);
    }

    @Override
    public Notification readNotification(String notificationid) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException {
        return libClient.readNotificationLib(notificationid);
    }

    @Override
    public boolean setNotificationRead(String notificationidToSet) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException {
        return libClient.setNotificationReadLib(notificationidToSet);
    }

    @Override
    public List<Notification> getAllNotificationByUser(String userid, int limit) throws NotificationTypeNotFoundException, ColumnNameNotFoundException {
        return libClient.getAllNotificationByUserLib(userid, limit);
    }

    @Override
    public List<Notification> getUnreadNotificationsByUser(String userid) throws NotificationTypeNotFoundException, ColumnNameNotFoundException, NotificationIDNotFoundException {
        return libClient.getUnreadNotificationsByUserLib(userid);
    }

    @Override
    public List<Notification> getRangeNotificationsByUser(String userid, int from, int quantity) throws NotificationTypeNotFoundException, ColumnNameNotFoundException, NotificationIDNotFoundException {
        return libClient.getRangeNotificationsByUserLib(userid, from, quantity);
    }

    @Override
    public boolean setAllNotificationReadByUser(String userid) throws NotificationTypeNotFoundException, ColumnNameNotFoundException {
        return libClient.setAllNotificationReadByUserLib(userid);
    }

    @Override
    public boolean checkUnreadNotifications(String userid) throws NotificationTypeNotFoundException, ColumnNameNotFoundException {
        return libClient.checkUnreadNotificationsLib(userid);
    }

    @Override
    public boolean checkUnreadMessagesNotifications(String userid) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException {
        return libClient.checkUnreadMessagesNotificationsLib(userid);
    }

    @Override
    public List<NotificationChannelType> getUserNotificationChannels(String userid, NotificationType notificationType) throws NotificationChannelTypeNotFoundException, NotificationTypeNotFoundException {
        return libClient.getUserNotificationChannelsLib(userid, notificationType);
    }

    @Override
    public boolean setUserNotificationPreferences(String userid, Map<NotificationType, NotificationChannelType[]> enabledChannels) {
        if (enabledChannels != null) {
            for (NotificationType notificationType : enabledChannels.keySet()) {
                _log.debug("Type: " + notificationType.toString());
                for (NotificationChannelType channelType : enabledChannels.get(notificationType)) {
                    _log.debug(channelType.toString());
                }
            }
        }
        return libClient.setUserNotificationPreferencesLib(userid, enabledChannels);
    }

    @Override
    public Map<NotificationType, NotificationChannelType[]> getUserNotificationPreferences(String userid) throws NotificationTypeNotFoundException, NotificationChannelTypeNotFoundException {
        return libClient.getUserNotificationPreferencesLib(userid);
    }

    @Override
    public boolean addComment(Comment comment) throws FeedIDNotFoundException {
        return libClient.addCommentLib(comment) != null;
    }

    @Override
    public Comment readCommentById(String commentId) throws CommentIDNotFoundException {
        return libClient.readCommentByIdLib(commentId);
    }

    @Override
    @Deprecated
    public List<Comment> getAllCommentByFeed(String feedid) {
        return this.getAllCommentByPost(feedid);
    }

    @Override
    public List<Comment> getAllCommentByPost(String postid) {
        return libClient.getAllCommentsByPostIdLib(postid);
    }

    @Override
    public List<Comment> getRecentCommentsByUserAndDate(String userid, long timeInMillis) throws Exception {
        return libClient.getRecentCommentsByUserAndDateLib(userid, timeInMillis);
    }

    @Override
    public boolean editComment(Comment comment2Edit) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, CommentIDNotFoundException, FeedIDNotFoundException {
        return libClient.editCommentLib(comment2Edit) != null;
    }

    @Override
    public boolean deleteComment(String commentid, String feedid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, CommentIDNotFoundException, FeedIDNotFoundException {
        return libClient.deleteCommentLib(commentid, feedid);
    }

    @Override
    public boolean like(Like like) throws FeedIDNotFoundException {
        return libClient.likeLib(like);
    }

    @Override
    public boolean unlike(String userid, String likeid, String feedid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, LikeIDNotFoundException, FeedIDNotFoundException {
        return libClient.unlikeLib(userid, likeid, feedid);
    }

    @Override
    @Deprecated
    public List<String> getAllLikedFeedIdsByUser(String userid) {
        return this.getAllLikedPostIdsByUser(userid);
    }

    @Override
    public List<String> getAllLikedPostIdsByUser(String userid) {
        return libClient.getAllLikedPostIdsByUserLib(userid);
    }

    @Override
    public List<Feed> getAllLikedFeedsByUser(String userid, int limit) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList<Feed> toReturn = new ArrayList<Feed>();
        List<String> likedPostIDs = this.getAllLikedPostIdsByUser(userid);
        if (likedPostIDs != null) {
            limit = limit > likedPostIDs.size() ? likedPostIDs.size() : limit;
            for (int i = likedPostIDs.size() - 1; i >= likedPostIDs.size() - limit; --i) {
                Feed toAdd = this.readFeed(likedPostIDs.get(i));
                if (toAdd.getType() == FeedType.TWEET || toAdd.getType() == FeedType.SHARE || toAdd.getType() == FeedType.PUBLISH) {
                    toReturn.add(toAdd);
                    _log.trace("Read recent post: " + likedPostIDs.get(i));
                    continue;
                }
                _log.trace("Read and skipped post: " + likedPostIDs.get(i) + " (Removed post)");
                limit = ++limit > likedPostIDs.size() ? likedPostIDs.size() : limit;
            }
        }
        return toReturn;
    }

    @Override
    public List<Post> getAllLikedPostsByUser(String userid, int limit) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        List<String> likedPostIDs = this.getAllLikedPostIdsByUser(userid);
        if (likedPostIDs != null) {
            limit = limit > likedPostIDs.size() ? likedPostIDs.size() : limit;
            for (int i = likedPostIDs.size() - 1; i >= likedPostIDs.size() - limit; --i) {
                Post toAdd = this.readPost(likedPostIDs.get(i));
                if (toAdd.getType() == PostType.TWEET || toAdd.getType() == PostType.SHARE || toAdd.getType() == PostType.PUBLISH) {
                    toReturn.add(toAdd);
                    _log.trace("Read recent post: " + likedPostIDs.get(i));
                    continue;
                }
                _log.trace("Read and skipped post: " + likedPostIDs.get(i) + " (Removed post)");
                limit = ++limit > likedPostIDs.size() ? likedPostIDs.size() : limit;
            }
        }
        return toReturn;
    }

    @Override
    public List<Feed> getRecentLikedFeedsByUserAndDate(String userid, long timeInMillis) throws IllegalArgumentException {
        ArrayList<Feed> toReturn = new ArrayList<Feed>();
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        if (userid == null || userid.isEmpty()) {
            throw new IllegalArgumentException("the userId parameter cannot be null/empty");
        }
        List<String> likedPostsIdsByUser = this.getAllLikedFeedIdsByUser(userid);
        if (likedPostsIdsByUser != null && !likedPostsIdsByUser.isEmpty()) {
            for (int i = likedPostsIdsByUser.size() - 1; i >= 0; --i) {
                String postid = likedPostsIdsByUser.get(i);
                try {
                    boolean isPostOk;
                    Feed toCheck = this.readFeed(postid);
                    boolean bl = isPostOk = toCheck.getType() == FeedType.TWEET || toCheck.getType() == FeedType.SHARE || toCheck.getType() == FeedType.PUBLISH;
                    if (!isPostOk) continue;
                    List<Like> likes = this.getAllLikesByFeed(postid);
                    for (Like like : likes) {
                        if (like.getTime().getTime() < timeInMillis || !like.getUserid().equals(userid)) continue;
                        toReturn.add(toCheck);
                    }
                    continue;
                }
                catch (Exception e) {
                    _log.error("Skipped post with id " + postid, (Throwable)e);
                }
            }
        }
        Collections.sort(toReturn, Collections.reverseOrder());
        return toReturn;
    }

    @Override
    public List<Post> getRecentLikedPostsByUserAndDate(String userid, long timeInMillis) throws IllegalArgumentException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        if (userid == null || userid.isEmpty()) {
            throw new IllegalArgumentException("the userId parameter cannot be null/empty");
        }
        List<String> likedPostsIdsByUser = this.getAllLikedPostIdsByUser(userid);
        if (likedPostsIdsByUser != null && !likedPostsIdsByUser.isEmpty()) {
            for (int i = likedPostsIdsByUser.size() - 1; i >= 0; --i) {
                String postid = likedPostsIdsByUser.get(i);
                try {
                    boolean isPostOk;
                    Post toCheck = this.readPost(postid);
                    boolean bl = isPostOk = toCheck.getType() == PostType.TWEET || toCheck.getType() == PostType.SHARE || toCheck.getType() == PostType.PUBLISH;
                    if (!isPostOk) continue;
                    List<Like> likes = this.getAllLikesByPost(postid);
                    for (Like like : likes) {
                        if (like.getTime().getTime() < timeInMillis || !like.getUserid().equals(userid)) continue;
                        toReturn.add(toCheck);
                    }
                    continue;
                }
                catch (Exception e) {
                    _log.error("Skipped post with id " + postid, (Throwable)e);
                }
            }
        }
        Collections.sort(toReturn, Collections.reverseOrder());
        return toReturn;
    }

    @Override
    @Deprecated
    public List<Like> getAllLikesByFeed(String feedid) {
        return this.getAllLikesByPost(feedid);
    }

    @Override
    public List<Like> getAllLikesByPost(String postid) {
        return libClient.getAllLikesByPostLib(postid);
    }

    @Override
    public boolean saveHashTags(String feedid, String vreid, List<String> hashtags) throws FeedIDNotFoundException {
        return libClient.saveHashTagsLib(feedid, vreid, hashtags);
    }

    @Override
    public boolean deleteHashTags(String feedid, String vreid, List<String> hashtags) throws FeedIDNotFoundException {
        return libClient.deleteHashTagsLib(feedid, vreid, hashtags);
    }

    @Override
    public boolean saveHashTagsComment(String commentId, String vreid, List<String> hashtags) throws CommentIDNotFoundException {
        return libClient.saveHashTagsCommentLib(commentId, vreid, hashtags);
    }

    @Override
    public boolean deleteHashTagsComment(String commentId, String vreid, List<String> hashtags) throws CommentIDNotFoundException {
        return libClient.deleteHashTagsCommentLib(commentId, vreid, hashtags);
    }

    @Override
    public Map<String, Integer> getVREHashtagsWithOccurrence(String vreid) {
        return libClient.getVREHashtagsWithOccurrenceLib(vreid);
    }

    @Override
    public Map<String, Integer> getVREHashtagsWithOccurrenceFilteredByTime(String vreid, long timestamp) {
        return libClient.getVREHashtagsWithOccurrenceFilteredByTimeLib(vreid, timestamp);
    }

    @Override
    public List<Feed> getVREFeedsByHashtag(String vreid, String hashtag) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        List<Post> posts = this.getVREPostsByHashtag(vreid, hashtag);
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        if (posts != null) {
            for (Post post : posts) {
                feeds.add(DBCassandraAstyanaxImpl.post2feed(post));
            }
        }
        return feeds;
    }

    @Override
    public List<Post> getVREPostsByHashtag(String vreid, String hashtag) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        return libClient.getVREPostsByHashtagLib(vreid, hashtag);
    }

    @Override
    public String isExistingInvite(String vreid, String email) {
        return libClient.isExistingInviteLib(vreid, email);
    }

    @Override
    public InviteOperationResult saveInvite(Invite invite) throws AddressException {
        return libClient.saveInviteLib(invite);
    }

    @Override
    public Invite readInvite(String inviteid) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        return libClient.readInviteLib(inviteid);
    }

    @Override
    public boolean setInviteStatus(String vreid, String email, InviteStatus status) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        return libClient.setInviteStatusLib(vreid, email, status);
    }

    @Override
    public List<Invite> getInvitedEmailsByVRE(String vreid, InviteStatus ... status) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        return libClient.getInvitedEmailsByVRELib(vreid, status);
    }

    @Override
    public List<Attachment> getAttachmentsByFeedId(String feedId) throws FeedIDNotFoundException {
        return libClient.getAttachmentsByFeedIdLib(feedId);
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public List<String> getAllVREIds() {
        return libClient.getAllVREIdsLib();
    }
}

