/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.additionalemailaddresses.interceptor;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.User;
import com.liferay.portal.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.util.portlet.PortletProps;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.springframework.web.portlet.handler.HandlerInterceptorAdapter;

public class InterceptAll
extends HandlerInterceptorAdapter {
    private static Log log = LogFactoryUtil.getLog(InterceptAll.class);

    public boolean preHandleResource(ResourceRequest request, ResourceResponse response, Object handler) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)request);
        long maxNumEmails = Long.parseLong(PortletProps.get((String)"max-num-emails"));
        long userId = serviceContext.getUserId();
        User user = UserLocalServiceUtil.getUser((long)userId);
        if (request.getParameter("emailAddressId") == null && request.getParameter("emailAddress") == null) {
            return true;
        }
        if (request.getParameter("emailAddressId") != null) {
            long emailAddressId = ParamUtil.getLong((PortletRequest)request, (String)"emailAddressId");
            EmailAddress emailAddress = EmailAddressLocalServiceUtil.getEmailAddress((long)emailAddressId);
            if (emailAddress.getUserId() == user.getUserId()) {
                return true;
            }
            log.error((Object)("User " + emailAddress.getUserName() + " can not perform this Action"));
            return false;
        }
        if (request.getParameter("emailAddress") != null) {
            if ((long)user.getEmailAddresses().size() >= maxNumEmails) {
                log.error((Object)("User " + user.getScreenName() + " has the maximun number of emails"));
                return false;
            }
            return true;
        }
        return true;
    }

    public void afterResourceCompletion(ResourceRequest request, ResourceResponse response, Object handler, Exception ex) throws Exception {
        super.afterResourceCompletion(request, response, handler, ex);
    }
}

