/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.project;

import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.plugin.PluginConfiguration;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.principal.PrincipalProject;
import gr.cite.geoanalytics.dataaccess.entities.project.ProjectLayer;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"Project\"")
public class Project
implements Entity,
Identifiable,
Stampable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"PRJ_ID\"", nullable=false)
    private UUID id = null;
    @ManyToOne
    @JoinColumn(name="\"PRJ_Tenant\"", nullable=false)
    private Tenant tenant = null;
    @Column(name="\"PRJ_Name\"", nullable=false, length=250)
    private String name = null;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Basic(fetch=FetchType.LAZY)
    @Column(name="\"PRJ_Description\"", nullable=true)
    private String description = null;
    @Column(name="\"PRJ_Extent\"", nullable=false, length=250)
    private String extent = null;
    @Column(name="\"PRJ_Status\"", nullable=false)
    private short status = 1;
    @Column(name="\"PRJ_IsTemplate\"", nullable=false)
    private Short isTemplate = 0;
    @Column(name="\"PRJ_Shape\"", nullable=true)
    @Type(type="org.hibernate.type.PostgresUUIDType")
    private UUID shape = null;
    @ManyToOne
    @JoinColumn(name="\"PRJ_Creator\"", nullable=false)
    private Principal creator = null;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL})
    private Set<PrincipalProject> principalProject = new HashSet<PrincipalProject>();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"PRJ_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"PRJ_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL})
    private Set<PluginConfiguration> pluginConfiguration = new HashSet<PluginConfiguration>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<ProjectLayer> projectLayers = new HashSet<ProjectLayer>(0);

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExtent() {
        return this.extent;
    }

    public void setExtent(String extent) {
        this.extent = extent;
    }

    public ProjectStatus getStatus() {
        return ProjectStatus.fromStatusCode(this.status);
    }

    public void setStatus(ProjectStatus status) {
        this.status = status.statusCode();
    }

    public boolean getIsTemplate() {
        if (this.isTemplate == null) {
            return false;
        }
        return this.isTemplate != 0;
    }

    public void setIsTemplate(boolean isTemplate) {
        this.isTemplate = (short)(isTemplate ? 1 : 0);
    }

    public UUID getShape() {
        return this.shape;
    }

    public void setShape(UUID shape) {
        this.shape = shape;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Set<PluginConfiguration> getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(Set<PluginConfiguration> pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public Set<PrincipalProject> getPrincipalProject() {
        return this.principalProject;
    }

    public void setPrincipalProject(Set<PrincipalProject> principalProject) {
        this.principalProject = principalProject;
    }

    public Set<ProjectLayer> getProjectLayers() {
        return this.projectLayers;
    }

    public void setProjectLayers(Set<ProjectLayer> projectLayers) {
        this.projectLayers = projectLayers;
    }

    public String toString() {
        return "Project(id=" + this.getId() + " name=" + this.getName() + " description=" + this.getDescription() + " status=" + (Object)((Object)this.getStatus()) + " isTemplate=" + this.getIsTemplate() + " creation=" + this.getCreationDate() + " lastUpdate=" + this.getLastUpdate() + " creator=" + (this.creator != null ? this.creator.getId() : null) + " customer=" + (this.tenant != null ? this.tenant.getId() : null) + " shape=" + (this.shape != null ? this.shape : null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static enum ProjectStatus {
        DELETED(-1),
        ARCHIVE(0),
        ACTIVE(2);

        private final short statusCode;
        private static final Map<Short, ProjectStatus> lookup;

        private ProjectStatus(short statusCode) {
            this.statusCode = statusCode;
        }

        public short statusCode() {
            return this.statusCode;
        }

        public static ProjectStatus fromStatusCode(short statusCode) {
            return lookup.get(statusCode);
        }

        static {
            lookup = new HashMap<Short, ProjectStatus>();
            for (ProjectStatus s : EnumSet.allOf(ProjectStatus.class)) {
                lookup.put(s.statusCode(), s);
            }
        }
    }
}

