/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation;

import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.TermStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlSeeAlso(value={TermStyle.class})
public class GeoStyle {
    private List<TermStyle> termStyles = new ArrayList<TermStyle>();
    @XmlTransient
    private Map<String, TermStyle> lookup = new HashMap<String, TermStyle>();

    public List<TermStyle> getTermStyles() {
        return this.termStyles;
    }

    @XmlElement
    public void setTermStyles(List<TermStyle> termStyles) {
        this.termStyles = termStyles;
        this.lookup = new HashMap<String, TermStyle>();
        for (TermStyle ts : termStyles) {
            this.lookup.put(ts.getId(), ts);
        }
    }

    public TermStyle getTermStyle(String id) {
        return this.lookup.get(id);
    }

    public void addTermStyle(TermStyle ts) {
        if (this.lookup.containsKey(ts.getId())) {
            this.removeTermStyle(ts.getId());
        }
        this.lookup.put(ts.getId(), ts);
        this.termStyles.add(ts);
    }

    public void removeTermStyle(String id) {
        TermStyle ts = this.lookup.get(id);
        if (ts == null) {
            return;
        }
        this.termStyles.remove(ts);
        this.lookup.remove(ts);
    }
}

