/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import com.vividsolutions.jts.geom.CoordinateSequence;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class GMLWriter {
    static final QualifiedName COORDINATES = new QualifiedName("http://www.opengis.net/gml", "coordinates", "gml");
    static final QualifiedName POS_LIST = new QualifiedName("http://www.opengis.net/gml", "posList", "gml");
    private static final double DECIMAL_MIN = Math.pow(10.0, -3.0);
    private static final double DECIMAL_MAX = Math.pow(10.0, 7.0);
    private static final FieldPosition ZERO = new FieldPosition(0);
    ContentHandler handler;
    NamespaceSupport namespaces;
    StringBuffer sb = new StringBuffer();
    char[] buffer;
    private QualifiedName coordinates;
    private QualifiedName posList;
    private double scale;
    private final NumberFormat coordFormatter = NumberFormat.getInstance(Locale.US);
    private boolean forceDecimal;

    public GMLWriter(ContentHandler delegate, NamespaceSupport namespaces, int numDecimals, boolean forceDecimal, String gmlPrefix) {
        this.handler = delegate;
        this.namespaces = namespaces;
        String gmlUri = namespaces.getURI(gmlPrefix);
        if (gmlUri == null) {
            gmlUri = "http://www.opengis.net/gml";
        }
        this.coordinates = COORDINATES.derive(gmlPrefix, gmlUri);
        this.posList = POS_LIST.derive(gmlPrefix, gmlUri);
        this.coordFormatter.setMaximumFractionDigits(numDecimals);
        this.coordFormatter.setGroupingUsed(false);
        this.scale = Math.pow(10.0, numDecimals);
        this.forceDecimal = forceDecimal;
    }

    public void setDocumentLocator(Locator locator) {
        this.handler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.handler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.handler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.handler.endPrefixMapping(prefix);
    }

    public void startElement(QualifiedName qn, Attributes atts) throws SAXException {
        String qualifiedName = qn.getQualifiedName();
        if (qualifiedName == null) {
            qualifiedName = this.qualify(qn.getNamespaceURI(), qn.getLocalPart(), null);
        }
        if (atts == null) {
            atts = new AttributesImpl();
        }
        if (qualifiedName != null) {
            String localName = null;
            if (qualifiedName.contains(":")) {
                localName = qualifiedName.split(":")[1];
            }
            this.handler.startElement(qn.getNamespaceURI(), localName, qualifiedName, atts);
        } else {
            this.handler.startElement(qn.getNamespaceURI(), qn.getLocalPart(), null, atts);
        }
    }

    private String qualify(String uri, String localName, String qName) {
        if (qName == null) {
            String prefix = this.namespaces.getPrefix(uri);
            if (prefix == null) {
                return localName;
            }
            return prefix + ":" + localName;
        }
        return qName;
    }

    public void endElement(QualifiedName qn) throws SAXException {
        String qualifiedName = qn.getQualifiedName();
        if (qualifiedName == null) {
            qualifiedName = this.qualify(qn.getNamespaceURI(), qn.getLocalPart(), null);
        }
        if (qualifiedName != null) {
            this.handler.endElement(null, null, qualifiedName);
        } else {
            this.handler.endElement(qn.getNamespaceURI(), qn.getLocalPart(), null);
        }
    }

    private void characters(char[] ch, int start, int length) throws SAXException {
        this.handler.characters(ch, start, length);
    }

    void characters(StringBuffer sb) throws SAXException {
        int length = sb.length();
        if (this.buffer == null || this.buffer.length < length) {
            this.buffer = new char[length];
        }
        sb.getChars(0, length, this.buffer, 0);
        this.characters(this.buffer, 0, length);
    }

    void characters(String s) throws SAXException {
        s = XMLUtils.removeXMLInvalidChars(s);
        int length = s.length();
        if (this.buffer == null || this.buffer.length < length) {
            this.buffer = new char[length];
        }
        s.getChars(0, length, this.buffer, 0);
        this.characters(this.buffer, 0, length);
    }

    public void coordinates(CoordinateSequence cs) throws SAXException {
        this.startElement(this.coordinates, null);
        this.coordinates(cs, ',', ' ', this.sb);
        this.characters(this.sb);
        this.endElement(this.coordinates);
    }

    public void position(double x, double y, double z) throws SAXException {
        this.position(x, y, z, this.sb);
        this.characters(this.sb);
    }

    void position(double x, double y, double z, StringBuffer sb) {
        sb.setLength(0);
        this.appendDecimal(x);
        if (!Double.isNaN(y)) {
            sb.append(" ");
            this.appendDecimal(y);
        }
        if (!Double.isNaN(z)) {
            sb.append(" ");
            this.appendDecimal(z);
        }
    }

    void positions(CoordinateSequence coordinates) {
        this.coordinates(coordinates, ' ', ' ', this.sb);
    }

    void coordinates(CoordinateSequence coordinates, char cs, char ts, StringBuffer sb) {
        sb.setLength(0);
        int n = coordinates.size();
        int dim = CoordinateSequences.coordinateDimension(coordinates);
        for (int i = 0; i < n; ++i) {
            this.appendDecimal(coordinates.getX(i)).append(cs);
            this.appendDecimal(coordinates.getY(i));
            if (dim == 3) {
                sb.append(cs);
                this.appendDecimal(coordinates.getOrdinate(i, 2));
            }
            sb.append(ts);
        }
        sb.setLength(sb.length() - 1);
    }

    public void ordinate(double x) throws SAXException {
        this.sb.setLength(0);
        this.appendDecimal(x);
        this.characters(this.sb);
    }

    private StringBuffer appendDecimal(double x) {
        if (Math.abs(x) >= DECIMAL_MIN && x < DECIMAL_MAX || x == 0.0) {
            long lx = (long)(x = this.truncate(x));
            if ((double)lx == x) {
                this.sb.append(lx);
            } else {
                this.sb.append(x);
            }
        } else if (this.forceDecimal) {
            this.coordFormatter.format(x, this.sb, ZERO);
        } else {
            this.sb.append(this.truncate(x));
        }
        return this.sb;
    }

    final double truncate(double x) {
        return Math.floor(x * this.scale + 0.5) / this.scale;
    }

    public void posList(CoordinateSequence coordinateSequence) throws SAXException {
        this.startElement(this.posList, null);
        this.positions(coordinateSequence);
        this.characters(this.sb);
        this.endElement(this.posList);
    }
}

