/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.util.InternationalString;
import org.picocontainer.MutablePicoContainer;

public class SLDFeatureTypeStyleBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDFeatureTypeStyleBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    @Override
    public QName getTarget() {
        return SLD.FEATURETYPESTYLE;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return FeatureTypeStyle.class;
    }

    @Override
    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        FeatureTypeStyle featureTypeStyle = this.styleFactory.createFeatureTypeStyle();
        if (node.hasChild("Name")) {
            featureTypeStyle.setName((String)node.getChildValue("Name"));
        }
        if (node.hasChild("Title")) {
            featureTypeStyle.getDescription().setTitle((InternationalString)node.getChildValue("Title"));
        }
        if (node.hasChild("Abstract")) {
            featureTypeStyle.getDescription().setAbstract((InternationalString)node.getChildValue("Abstract"));
        }
        if (node.hasChild("FeatureTypeName")) {
            Object ftn = node.getChildValue("FeatureTypeName");
            if (ftn instanceof QName) {
                QName qn = (QName)ftn;
                ftn = qn.getPrefix() != null && !"".equals(qn.getPrefix().trim()) ? qn.getPrefix() + ":" + qn.getLocalPart() : qn.getLocalPart();
            }
            featureTypeStyle.setFeatureTypeName(ftn.toString());
        }
        if (node.hasChild("SemanticTypeIdentifier")) {
            List ids = node.getChildValues("SemanticTypeIdentifier");
            featureTypeStyle.setSemanticTypeIdentifiers(ids.toArray(new String[ids.size()]));
        }
        if (node.hasChild("Rule")) {
            List rules = node.getChildValues("Rule");
            featureTypeStyle.setRules(rules.toArray(new Rule[rules.size()]));
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            featureTypeStyle.getOptions().put(param.getName(), param.getExpression().evaluate(null, String.class));
        }
        return featureTypeStyle;
    }
}

