/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.filter.visitor.RangeCombiner;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.VolatileFunction;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.GmlObjectId;
import org.opengis.filter.identity.Identifier;

public class SimplifyingFilterVisitor
extends DuplicatingFilterVisitor {
    public static final FIDValidator ANY_FID_VALID = new FIDValidator(){

        @Override
        public boolean isValid(String fid) {
            return true;
        }
    };
    FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
    protected FeatureType featureType;
    private FIDValidator fidValidator = ANY_FID_VALID;
    private boolean rangeSimplicationEnabled = false;

    public void setFIDValidator(FIDValidator validator) {
        this.fidValidator = validator == null ? ANY_FID_VALID : validator;
    }

    public void setFeatureType(FeatureType featureType) {
        this.featureType = featureType;
    }

    @Override
    public Object visit(And filter, Object extraData) {
        List<Filter> filters = this.collect(filter, And.class, extraData, new ArrayList<Filter>());
        filters = this.basicAndSimplification(filters);
        if ((filters = this.extraAndSimplification(extraData, filters)).size() == 0) {
            return Filter.INCLUDE;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return this.getFactory(extraData).and(filters);
    }

    protected List<Filter> basicAndSimplification(List<Filter> filters) {
        if (this.rangeSimplicationEnabled && this.featureType != null && this.isSimpleFeature()) {
            RangeCombiner.And combiner = new RangeCombiner.And(this.ff, this.featureType, filters);
            filters = combiner.getReducedFilters();
        }
        ArrayList<Filter> simplified = new ArrayList<Filter>(filters.size());
        for (Filter child : filters) {
            if (child == Filter.EXCLUDE) {
                return Arrays.asList(Filter.EXCLUDE);
            }
            if (child == Filter.INCLUDE) continue;
            simplified.add(child);
        }
        for (int i = 0; i < simplified.size(); ++i) {
            int j = i + 1;
            while (j < simplified.size()) {
                Filter f2;
                Filter f1 = (Filter)simplified.get(i);
                if (f1.equals(f2 = (Filter)simplified.get(j))) {
                    simplified.remove(j);
                    continue;
                }
                if (this.dualFilters(f1, f2)) {
                    return Arrays.asList(Filter.EXCLUDE);
                }
                ++j;
            }
        }
        return simplified;
    }

    protected <T extends BinaryLogicOperator> List<Filter> collect(T filter, Class<T> type, Object extraData, List<Filter> collected) {
        for (Filter child : filter.getChildren()) {
            if (type.isInstance(child)) {
                BinaryLogicOperator and = (BinaryLogicOperator)child;
                this.collect(and, type, extraData, collected);
                continue;
            }
            Filter cloned = (Filter)child.accept(this, extraData);
            if (type.isInstance(cloned)) {
                BinaryLogicOperator and = (BinaryLogicOperator)cloned;
                this.collect(and, type, extraData, collected);
                continue;
            }
            collected.add(cloned);
        }
        return collected;
    }

    private boolean dualFilters(Filter f1, Filter f2) {
        if (f1 instanceof Not) {
            Not not = (Not)f1;
            return f2.equals(not.getFilter());
        }
        if (f2 instanceof Not) {
            Not not = (Not)f2;
            return f1.equals(not.getFilter());
        }
        if (f1 instanceof PropertyIsEqualTo && f2 instanceof PropertyIsNotEqualTo || f1 instanceof PropertyIsNotEqualTo && f2 instanceof PropertyIsEqualTo) {
            PropertyIsNotEqualTo ne;
            PropertyIsEqualTo e;
            if (f2 instanceof PropertyIsEqualTo) {
                e = (PropertyIsEqualTo)f2;
                ne = (PropertyIsNotEqualTo)f1;
            } else {
                e = (PropertyIsEqualTo)f1;
                ne = (PropertyIsNotEqualTo)f2;
            }
            if (!this.isSimpleFeature()) {
                return false;
            }
            return e.getExpression1().equals(ne.getExpression1()) && e.getExpression2().equals(ne.getExpression2()) || e.getExpression2().equals(ne.getExpression1()) && e.getExpression1().equals(ne.getExpression2());
        }
        return false;
    }

    @Override
    public Object visit(Or filter, Object extraData) {
        List<Filter> filters = this.collect(filter, Or.class, extraData, new ArrayList<Filter>());
        filters = this.basicOrSimplification(filters);
        if ((filters = this.extraOrSimplification(extraData, filters)).size() == 0) {
            return Filter.EXCLUDE;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return this.getFactory(extraData).or(filters);
    }

    protected List<Filter> basicOrSimplification(List<Filter> filters) {
        if (this.rangeSimplicationEnabled && this.featureType != null && this.isSimpleFeature()) {
            RangeCombiner.Or combiner = new RangeCombiner.Or(this.ff, this.featureType, filters);
            filters = combiner.getReducedFilters();
        }
        ArrayList<Filter> simplified = new ArrayList<Filter>(filters.size());
        for (Filter child : filters) {
            if (child == Filter.INCLUDE) {
                return Arrays.asList(Filter.INCLUDE);
            }
            if (child == Filter.EXCLUDE) continue;
            simplified.add(child);
        }
        for (int i = 0; i < simplified.size(); ++i) {
            int j = i + 1;
            while (j < simplified.size()) {
                Filter f2;
                Filter f1 = (Filter)simplified.get(i);
                if (f1.equals(f2 = (Filter)simplified.get(j))) {
                    simplified.remove(j);
                    continue;
                }
                if (this.dualFilters(f1, f2)) {
                    return Arrays.asList(Filter.INCLUDE);
                }
                ++j;
            }
        }
        return simplified;
    }

    protected List<Filter> extraAndSimplification(Object extraData, List<Filter> filters) {
        return filters;
    }

    protected List<Filter> extraOrSimplification(Object extraData, List<Filter> filters) {
        return filters;
    }

    @Override
    public Object visit(Id filter, Object extraData) {
        if (filter.getIDs().size() == 0) {
            return Filter.EXCLUDE;
        }
        HashSet<Identifier> validFids = new HashSet<Identifier>();
        for (Identifier id : filter.getIdentifiers()) {
            if (!(id instanceof FeatureId) && !(id instanceof GmlObjectId) || !this.fidValidator.isValid((String)id.getID())) continue;
            validFids.add(id);
        }
        Filter validIdFilter = validFids.size() == 0 ? Filter.EXCLUDE : this.getFactory(extraData).id(validFids);
        return validIdFilter;
    }

    @Override
    public Object visit(Not filter, Object extraData) {
        FilterFactory2 ff = this.getFactory(extraData);
        Filter inner = filter.getFilter();
        if (inner instanceof Not) {
            Not innerNot = (Not)inner;
            return innerNot.getFilter().accept(this, extraData);
        }
        if (inner == Filter.INCLUDE) {
            return Filter.EXCLUDE;
        }
        if (inner == Filter.EXCLUDE) {
            return Filter.INCLUDE;
        }
        if (inner instanceof PropertyIsBetween && this.isSimpleFeature()) {
            PropertyIsBetween pb = (PropertyIsBetween)inner.accept(this, extraData);
            PropertyIsLessThan lt = ff.less(pb.getExpression(), pb.getLowerBoundary());
            PropertyIsGreaterThan gt = ff.greater(pb.getExpression(), pb.getUpperBoundary());
            return ff.or(lt, gt);
        }
        if (inner instanceof PropertyIsEqualTo && this.isSimpleFeature()) {
            PropertyIsEqualTo pe = (PropertyIsEqualTo)inner.accept(this, extraData);
            return ff.notEqual(pe.getExpression1(), pe.getExpression2(), pe.isMatchingCase());
        }
        if (inner instanceof PropertyIsNotEqualTo && this.isSimpleFeature()) {
            PropertyIsNotEqualTo pe = (PropertyIsNotEqualTo)inner.accept(this, extraData);
            return ff.equal(pe.getExpression1(), pe.getExpression2(), pe.isMatchingCase());
        }
        if (inner instanceof PropertyIsGreaterThan && this.isSimpleFeature()) {
            PropertyIsGreaterThan pg = (PropertyIsGreaterThan)inner.accept(this, extraData);
            return ff.lessOrEqual(pg.getExpression1(), pg.getExpression2(), pg.isMatchingCase());
        }
        if (inner instanceof PropertyIsGreaterThanOrEqualTo && this.isSimpleFeature()) {
            PropertyIsGreaterThanOrEqualTo pg = (PropertyIsGreaterThanOrEqualTo)inner.accept(this, extraData);
            return ff.less(pg.getExpression1(), pg.getExpression2(), pg.isMatchingCase());
        }
        if (inner instanceof PropertyIsLessThan && this.isSimpleFeature()) {
            PropertyIsLessThan pl = (PropertyIsLessThan)inner.accept(this, extraData);
            return ff.greaterOrEqual(pl.getExpression1(), pl.getExpression2(), pl.isMatchingCase());
        }
        if (inner instanceof PropertyIsLessThanOrEqualTo && this.isSimpleFeature()) {
            PropertyIsLessThanOrEqualTo pl = (PropertyIsLessThanOrEqualTo)inner.accept(this, extraData);
            return ff.greater(pl.getExpression1(), pl.getExpression2(), pl.isMatchingCase());
        }
        if (inner instanceof And) {
            And and = (And)inner;
            List<Filter> children = and.getChildren();
            ArrayList<Filter> negatedChildren = new ArrayList<Filter>();
            for (Filter child : children) {
                negatedChildren.add((Filter)ff.not(child).accept(this, extraData));
            }
            return ff.or(negatedChildren);
        }
        if (inner instanceof Or) {
            Or or = (Or)inner;
            List<Filter> children = or.getChildren();
            ArrayList<Filter> negatedChildren = new ArrayList<Filter>();
            for (Filter child : children) {
                negatedChildren.add((Filter)ff.not(child).accept(this, extraData));
            }
            return ff.and(negatedChildren);
        }
        return super.visit(filter, extraData);
    }

    protected boolean isSimpleFeature() {
        return this.featureType instanceof SimpleFeatureType;
    }

    @Override
    public Object visit(Function function, Object extraData) {
        if (this.isVolatileFunction(function)) {
            return super.visit(function, extraData);
        }
        if (this.attributeExtractor == null) {
            this.attributeExtractor = new FilterAttributeExtractor();
        } else {
            this.attributeExtractor.clear();
        }
        function.accept(this.attributeExtractor, null);
        if (this.attributeExtractor.isConstantExpression()) {
            Object result = function.evaluate(null);
            return this.ff.literal(result);
        }
        return super.visit(function, extraData);
    }

    protected boolean isVolatileFunction(Function function) {
        return function instanceof VolatileFunction;
    }

    public static Filter simplify(Filter filter) {
        return SimplifyingFilterVisitor.simplify(filter, null);
    }

    public static Filter simplify(Filter filter, FeatureType featureType) {
        if (filter == Filter.INCLUDE || filter == Filter.EXCLUDE || filter == null) {
            return filter;
        }
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setFeatureType(featureType);
        return (Filter)filter.accept(visitor, null);
    }

    protected boolean isConstant(Expression ex) {
        if (ex instanceof Literal) {
            return true;
        }
        if (ex instanceof NilExpression) {
            return true;
        }
        if (ex instanceof PropertyName) {
            return false;
        }
        this.attributeExtractor.clear();
        ex.accept(this.attributeExtractor, null);
        return this.attributeExtractor.isConstantExpression();
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) {
        PropertyIsBetween clone = (PropertyIsBetween)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression()) && this.isConstant(clone.getLowerBoundary()) && this.isConstant(clone.getUpperBoundary())) {
            return this.staticFilterEvaluate(clone);
        }
        return clone;
    }

    private Object staticFilterEvaluate(Filter filter) {
        if (filter.evaluate(null)) {
            return Filter.INCLUDE;
        }
        return Filter.EXCLUDE;
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    private Object simplifyBinaryComparisonOperator(BinaryComparisonOperator clone) {
        if (this.isConstant(clone.getExpression1()) && this.isConstant(clone.getExpression2())) {
            return this.staticFilterEvaluate(clone);
        }
        return clone;
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsLike filter, Object extraData) {
        PropertyIsLike clone = (PropertyIsLike)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression())) {
            return this.staticFilterEvaluate(clone);
        }
        return clone;
    }

    @Override
    public Object visit(PropertyIsNil filter, Object extraData) {
        PropertyIsNil clone = (PropertyIsNil)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression())) {
            return this.staticFilterEvaluate(clone);
        }
        return clone;
    }

    @Override
    public Object visit(PropertyIsNull filter, Object extraData) {
        PropertyIsNull clone = (PropertyIsNull)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression())) {
            return this.staticFilterEvaluate(clone);
        }
        return clone;
    }

    public boolean isRangeSimplicationEnabled() {
        return this.rangeSimplicationEnabled;
    }

    public void setRangeSimplicationEnabled(boolean rangeSimplicationEnabled) {
        this.rangeSimplicationEnabled = rangeSimplicationEnabled;
    }

    public static class TypeNameDotNumberFidValidator
    extends RegExFIDValidator {
        public TypeNameDotNumberFidValidator(String typeName) {
            super(typeName + "\\.\\d+");
        }
    }

    public static class RegExFIDValidator
    implements FIDValidator {
        private Pattern pattern;

        public RegExFIDValidator(String regularExpression) {
            this.pattern = Pattern.compile(regularExpression);
        }

        @Override
        public boolean isValid(String fid) {
            return this.pattern.matcher(fid).matches();
        }
    }

    public static interface FIDValidator {
        public boolean isValid(String var1);
    }
}

