/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.build.line;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.index.bintree.Bintree;
import com.vividsolutions.jts.index.bintree.Interval;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.graph.build.GraphBuilder;
import org.geotools.graph.build.basic.BasicGraphBuilder;
import org.geotools.graph.build.line.LineGraphGenerator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;

public class BasicLineGraphGenerator
implements LineGraphGenerator {
    private HashMap<Coordinate, Node> m_coord2node;
    private GraphBuilder m_builder;
    private double tolerance = 0.0;
    private Bintree spatialIndex;

    public BasicLineGraphGenerator() {
        this.m_coord2node = new HashMap();
        this.setGraphBuilder(new BasicGraphBuilder());
    }

    public BasicLineGraphGenerator(double tolerance) {
        this.tolerance = tolerance;
        this.spatialIndex = new Bintree();
        this.m_coord2node = new HashMap();
        this.setGraphBuilder(new BasicGraphBuilder());
    }

    @Override
    public Graphable add(Object obj) {
        Coordinate last;
        Node n2;
        LineSegment line = (LineSegment)obj;
        Coordinate first = line.p0;
        Node n1 = this.retrieveNode(first);
        if (n1 == null) {
            n1 = this.createNode(first);
        }
        if ((n2 = this.retrieveNode(last = line.p1)) == null) {
            n2 = this.createNode(last);
        }
        Edge e = this.getGraphBuilder().buildEdge(n1, n2);
        this.getGraphBuilder().addEdge(e);
        if (this.useTolerance()) {
            line = this.alterLine(line, n1, n2);
        }
        this.setObject(e, (Object)line);
        return e;
    }

    protected LineSegment alterLine(LineSegment line, Node n1, Node n2) {
        Coordinate c1added = (Coordinate)n1.getObject();
        Coordinate c2added = (Coordinate)n2.getObject();
        if (!c1added.equals2D(line.p0) || c2added.equals2D(line.p1)) {
            return new LineSegment(c1added, c2added);
        }
        return line;
    }

    @Override
    public Graphable get(Object obj) {
        LineSegment line = (LineSegment)obj;
        Node n1 = this.retrieveNode(line.p0);
        Node n2 = this.retrieveNode(line.p1);
        if (n1 == null || n2 == null) {
            return null;
        }
        return n1.getEdge(n2);
    }

    @Override
    public Graphable remove(Object obj) {
        LineSegment line = (LineSegment)obj;
        Node n1 = this.retrieveNode(line.p0);
        Node n2 = this.retrieveNode(line.p1);
        if (n1 == null || n2 == null) {
            return null;
        }
        Edge e = n1.getEdge(n2);
        this.getGraphBuilder().removeEdge(e);
        return e;
    }

    @Override
    public void setGraphBuilder(GraphBuilder builder) {
        this.m_builder = builder;
    }

    @Override
    public GraphBuilder getGraphBuilder() {
        return this.m_builder;
    }

    @Override
    public Graph getGraph() {
        return this.getGraphBuilder().getGraph();
    }

    public Map getNodeMap() {
        return this.m_coord2node;
    }

    @Override
    public Node getNode(Coordinate c) {
        return this.retrieveNode(c);
    }

    @Override
    public Edge getEdge(Coordinate c1, Coordinate c2) {
        Node n1 = this.retrieveNode(c1);
        Node n2 = this.retrieveNode(c2);
        return n1.getEdge(n2);
    }

    protected void setObject(Edge e, Object obj) {
        e.setObject(obj);
    }

    protected void setObject(Node n, Object obj) {
        n.setObject(obj);
    }

    private Node createNode(Coordinate c) {
        Node node = this.getGraphBuilder().buildNode();
        this.setObject(node, (Object)c);
        this.getGraphBuilder().addNode(node);
        this.m_coord2node.put(c, node);
        if (this.useTolerance()) {
            this.spatialIndex.insert(new Interval(c.y, c.y), c);
        }
        return node;
    }

    private Node retrieveNode(Coordinate c) {
        Node node = this.m_coord2node.get(c);
        if (node == null && this.useTolerance()) {
            node = this.findClosestNodeWithinTolerance(c);
        }
        return node;
    }

    protected boolean useTolerance() {
        return this.tolerance > 0.0;
    }

    private Node findClosestNodeWithinTolerance(Coordinate inCoord) {
        double closestDistance = Double.MAX_VALUE;
        Coordinate closestCoordinate = null;
        List list = this.spatialIndex.query(new Interval(inCoord.y - this.tolerance, inCoord.y + this.tolerance));
        for (Coordinate c : list) {
            double distance = inCoord.distance(c);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestCoordinate = c;
        }
        if (closestCoordinate != null && closestCoordinate.distance(inCoord) < this.tolerance) {
            return this.m_coord2node.get(closestCoordinate);
        }
        return null;
    }
}

