/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import org.geotools.factory.Hints;
import org.geotools.feature.AttributeImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.GeometryAttribute;
import org.opengis.filter.identity.FeatureId;

public class ComplexAttributeConverterFactory
implements ConverterFactory {
    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (ComplexAttribute.class.isAssignableFrom(source)) {
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source instanceof ComplexAttribute) {
                        Object valueMap = ((ComplexAttribute)source).getValue();
                        if (valueMap.isEmpty() || valueMap.size() > 1) {
                            return null;
                        }
                        source = valueMap.iterator().next();
                        if (AttributeImpl.class.equals(source.getClass())) {
                            return Converters.convert(((Attribute)source).getValue(), target);
                        }
                    }
                    return null;
                }
            };
        }
        if (GeometryAttribute.class.isAssignableFrom(source)) {
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source instanceof GeometryAttribute) {
                        return Converters.convert(((GeometryAttribute)source).getValue(), target);
                    }
                    return null;
                }
            };
        }
        if (FeatureId.class.isAssignableFrom(target) && String.class.isAssignableFrom(source)) {
            return new Converter(){

                public Object convert(Object source, Class target) {
                    if (source != null) {
                        return new FeatureIdImpl((String)source);
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

