/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicLong;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.Type;

public abstract class RowStoreAVL
implements PersistentStore {
    Database database;
    PersistentStoreCollection manager;
    TableSpaceManager tableSpace;
    Index[] indexList = Index.emptyArray;
    CachedObject[] accessorList = CachedObject.emptyArray;
    TableBase table;
    long baseElementCount;
    AtomicLong elementCount = new AtomicLong();
    long storageSize;
    boolean[] nullsList;
    double[][] searchCost;
    boolean isSchemaStore;
    private long timestamp;
    PersistentStore[] subStores = PersistentStore.emptyArray;

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    @Override
    public abstract boolean isMemory();

    @Override
    public void setMemory(boolean bl) {
    }

    @Override
    public abstract int getAccessCount();

    @Override
    public abstract void set(CachedObject var1);

    @Override
    public abstract CachedObject get(long var1, boolean var3);

    @Override
    public abstract CachedObject get(CachedObject var1, boolean var2);

    @Override
    public abstract void add(Session var1, CachedObject var2, boolean var3);

    @Override
    public boolean canRead(Session session, long l, int n, int[] nArray) {
        return true;
    }

    @Override
    public boolean canRead(Session session, CachedObject cachedObject, int n, int[] nArray) {
        RowAction rowAction = ((Row)cachedObject).rowAction;
        if (rowAction == null) {
            return true;
        }
        return rowAction.canRead(session, n);
    }

    @Override
    public abstract CachedObject get(RowInputInterface var1);

    @Override
    public CachedObject get(CachedObject cachedObject, RowInputInterface rowInputInterface) {
        return cachedObject;
    }

    @Override
    public CachedObject getNewInstance(int n) {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public int getDefaultObjectSize() {
        throw Error.runtimeError(201, "RowStoreAVL");
    }

    @Override
    public abstract CachedObject getNewCachedObject(Session var1, Object var2, boolean var3);

    @Override
    public abstract void removeAll();

    @Override
    public abstract void remove(CachedObject var1);

    @Override
    public abstract void commitPersistence(CachedObject var1);

    @Override
    public void postCommitAction(Session session, RowAction rowAction) {
    }

    @Override
    public abstract DataFileCache getCache();

    @Override
    public TableSpaceManager getSpaceManager() {
        return this.tableSpace;
    }

    @Override
    public void setSpaceManager(TableSpaceManager tableSpaceManager) {
        this.tableSpace = tableSpaceManager;
    }

    @Override
    public abstract void setCache(DataFileCache var1);

    @Override
    public abstract void release();

    @Override
    public PersistentStore getAccessorStore(Index index) {
        return null;
    }

    @Override
    public CachedObject getAccessor(Index index) {
        int n = index.getPosition();
        if (n >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Session session, Row row) {
        int n;
        row = (Row)this.get((CachedObject)row, false);
        for (n = 0; n < this.indexList.length; ++n) {
            this.indexList[n].delete(session, this, row);
        }
        for (n = 0; n < this.subStores.length; ++n) {
            this.subStores[n].delete(session, row);
        }
        row.delete(this);
        long l = this.elementCount.decrementAndGet();
        if (l > 16384L && l < this.baseElementCount / 2L) {
            RowStoreAVL rowStoreAVL = this;
            synchronized (rowStoreAVL) {
                this.baseElementCount = l;
                this.searchCost = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexRow(Session session, Row row) {
        block11: {
            int n;
            try {
                for (n = 0; n < this.indexList.length; ++n) {
                    this.indexList[n].insert(session, this, row);
                }
                int n2 = 0;
                try {
                    for (n2 = 0; n2 < this.subStores.length; ++n2) {
                        this.subStores[n2].indexRow(session, row);
                    }
                }
                catch (HsqlException hsqlException) {
                    int n3 = n2;
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.subStores[n2].delete(session, row);
                    }
                    throw hsqlException;
                }
                long l = this.elementCount.incrementAndGet();
                if (l <= 16384L || l <= this.baseElementCount * 2L) break block11;
                RowStoreAVL rowStoreAVL = this;
                synchronized (rowStoreAVL) {
                    this.baseElementCount = l;
                    this.searchCost = null;
                }
            }
            catch (HsqlException hsqlException) {
                int n4 = n;
                for (n = 0; n < n4; ++n) {
                    this.indexList[n].delete(session, this, row);
                }
                this.remove(row);
                throw hsqlException;
            }
        }
    }

    @Override
    public final void indexRows(Session session) {
        for (int i = 1; i < this.indexList.length; ++i) {
            this.setAccessor(this.indexList[i], null);
        }
        RowIterator rowIterator = this.rowIterator();
        while (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            ((RowAVL)row).clearNonPrimaryNodes();
            for (int i = 1; i < this.indexList.length; ++i) {
                this.indexList[i].insert(session, this, row);
            }
        }
    }

    @Override
    public final RowIterator rowIterator() {
        Index index = this.indexList[0];
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!this.indexList[i].isClustered()) continue;
            index = this.indexList[i];
            break;
        }
        return index.firstRow(this);
    }

    @Override
    public void setAccessor(Index index, CachedObject cachedObject) {
        Index index2 = index;
        this.accessorList[index2.getPosition()] = cachedObject;
    }

    @Override
    public void setAccessor(Index index, long l) {
    }

    @Override
    public void resetAccessorKeys(Session session, Index[] indexArray) {
        int n;
        Index[] indexArray2 = this.indexList;
        this.searchCost = null;
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.indexList == indexArray) {
            return;
        }
        CachedObject[] cachedObjectArray = this.accessorList;
        int n2 = this.indexList.length;
        int n3 = indexArray.length - this.indexList.length;
        if (n3 < -1) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        if (n3 == -1) {
            n2 = indexArray.length;
        } else {
            if (n3 == 0) {
                throw Error.runtimeError(201, "RowStoreAVL");
            }
            if (n3 != 1) {
                for (n = 0; n < n2 && this.indexList[n] == indexArray[n]; ++n) {
                }
                Index[] indexArray3 = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n, 1);
                indexArray3[n] = indexArray[n];
                this.resetAccessorKeys(session, indexArray3);
                this.resetAccessorKeys(session, indexArray);
                return;
            }
        }
        while (n < n2 && this.indexList[n] == indexArray[n]) {
            ++n;
        }
        this.accessorList = (CachedObject[])ArrayUtil.toAdjustedArray(this.accessorList, null, n, n3);
        this.indexList = indexArray;
        try {
            if (n3 > 0) {
                this.insertIndexNodes(session, this.indexList[0], this.indexList[n]);
            } else {
                this.dropIndexFromRows(this.indexList[0], indexArray2[n]);
            }
        }
        catch (HsqlException hsqlException) {
            this.accessorList = cachedObjectArray;
            this.indexList = indexArray2;
            throw hsqlException;
        }
    }

    @Override
    public Index[] getAccessorKeys() {
        return this.indexList;
    }

    @Override
    public synchronized double searchCost(Session session, Index index, int n, int n2) {
        if (n2 != 40) {
            return this.elementCount.get() / 2L;
        }
        if (index.isUnique() && n == index.getColumnCount()) {
            return 1.0;
        }
        int n3 = index.getPosition();
        if (this.searchCost == null || this.searchCost.length <= n3) {
            this.searchCost = new double[this.indexList.length][];
        }
        if (this.searchCost[n3] == null) {
            this.searchCost[index.getPosition()] = this.indexList[index.getPosition()].searchCost(session, this);
        }
        return this.searchCost[index.getPosition()][n - 1];
    }

    @Override
    public long elementCount() {
        Index index = this.indexList[0];
        if (this.elementCount.get() < 0L) {
            this.elementCount.set(((IndexAVL)index).getNodeCount(null, this));
        }
        return this.elementCount.get();
    }

    @Override
    public long elementCount(Session session) {
        int n;
        Index index = this.indexList[0];
        if (this.elementCount.get() < 0L) {
            this.elementCount.set(((IndexAVL)index).getNodeCount(session, this));
        }
        if (session != null && (n = session.database.txManager.getTransactionControl()) != 0) {
            switch (this.table.getTableType()) {
                case 4: 
                case 5: 
                case 7: {
                    return ((IndexAVL)index).getNodeCount(session, this);
                }
            }
        }
        return this.elementCount.get();
    }

    @Override
    public long elementCountUnique(Index index) {
        return 0L;
    }

    @Override
    public void setElementCount(Index index, long l, long l2) {
        this.elementCount.set(l);
    }

    @Override
    public boolean hasNull(int n) {
        return false;
    }

    @Override
    public void moveDataToSpace() {
    }

    @Override
    public final void moveData(Session session, PersistentStore persistentStore, int n, int n2) {
        SchemaObject schemaObject;
        Type type = null;
        Type type2 = null;
        Object object = null;
        if (n2 >= 0 && n != -1) {
            schemaObject = ((Table)this.table).getColumn(n);
            object = ((ColumnSchema)schemaObject).getDefaultValue(session);
            type2 = ((Table)this.table).getColumnTypes()[n];
        }
        if (n2 <= 0 && n != -1) {
            type = ((Table)persistentStore.getTable()).getColumnTypes()[n];
        }
        try {
            Object object2;
            Object[] objectArray;
            Row row;
            schemaObject = (Table)this.table;
            RowIterator rowIterator = persistentStore.rowIterator();
            while (rowIterator.hasNext()) {
                row = rowIterator.getNextRow();
                objectArray = row.getData();
                object2 = ((TableBase)((Object)schemaObject)).getEmptyRowData();
                Object object3 = null;
                if (n2 == 0 && n != -1) {
                    object3 = objectArray[n];
                    object = type2.convertToType(session, object3, type);
                }
                ArrayUtil.copyAdjustArray(objectArray, object2, object, n, n2);
                ((Table)schemaObject).systemSetIdentityColumn(session, (Object[])object2);
                if (((Table)schemaObject).hasGeneratedColumn()) {
                    ((Table)schemaObject).setGeneratedColumns(session, (Object[])object2);
                }
                ((Table)schemaObject).enforceTypeLimits(session, (Object[])object2);
                ((Table)schemaObject).enforceRowConstraints(session, (Object[])object2);
                Row row2 = (Row)this.getNewCachedObject(session, object2, false);
                this.indexRow(session, row2);
            }
            if (((Table)schemaObject).isTemp()) {
                return;
            }
            if (type != null && type.isLobType()) {
                rowIterator = persistentStore.rowIterator();
                while (rowIterator.hasNext()) {
                    row = rowIterator.getNextRow();
                    objectArray = row.getData();
                    object2 = objectArray[n];
                    if (object2 == null) continue;
                    session.sessionData.adjustLobUsageCount(object2, -1);
                }
            }
            if (type2 != null && type2.isLobType()) {
                rowIterator = this.rowIterator();
                while (rowIterator.hasNext()) {
                    row = rowIterator.getNextRow();
                    objectArray = row.getData();
                    object2 = objectArray[n];
                    if (object2 == null) continue;
                    session.sessionData.adjustLobUsageCount(object2, 1);
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw Error.error(460);
        }
    }

    @Override
    public void reindex(Session session, Index index) {
        this.setAccessor(index, null);
        RowIterator rowIterator = this.table.rowIterator(this);
        while (rowIterator.hasNext()) {
            RowAVL rowAVL = (RowAVL)rowIterator.getNextRow();
            rowAVL.getNode(index.getPosition()).delete();
            index.insert(session, this, rowAVL);
        }
    }

    @Override
    public void setReadOnly(boolean bl) {
    }

    @Override
    public void writeLock() {
    }

    @Override
    public void writeUnlock() {
    }

    void dropIndexFromRows(Index index, Index index2) {
        RowIterator rowIterator = index.firstRow(this);
        int n = index2.getPosition() - 1;
        while (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            int n2 = n - 1;
            NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
            while (n2-- > 0) {
                nodeAVL = nodeAVL.nNext;
            }
            nodeAVL.nNext = nodeAVL.nNext.nNext;
        }
        rowIterator.release();
    }

    boolean insertIndexNodes(Session session, Index index, Index index2) {
        int n = index2.getPosition();
        RowIterator rowIterator = index.firstRow(this);
        int n2 = 0;
        HsqlException hsqlException = null;
        try {
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                ((RowAVL)row).insertNode(n);
                ++n2;
                index2.insert(session, this, row);
            }
            rowIterator.release();
            return true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            hsqlException = Error.error(460);
        }
        catch (HsqlException hsqlException2) {
            hsqlException = hsqlException2;
        }
        rowIterator = index.firstRow(this);
        for (int i = 0; i < n2; ++i) {
            Row row = rowIterator.getNextRow();
            NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
            int n3 = n;
            while (--n3 > 0) {
                nodeAVL = nodeAVL.nNext;
            }
            nodeAVL.nNext = nodeAVL.nNext.nNext;
        }
        rowIterator.release();
        throw hsqlException;
    }

    void destroy() {
        if (this.indexList.length == 0) {
            return;
        }
        IndexAVL indexAVL = (IndexAVL)this.indexList[0];
        NodeAVL nodeAVL = (NodeAVL)this.accessorList[0];
        indexAVL.unlinkNodes(nodeAVL);
    }
}

