/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.google;

import com.github.scribejava.apis.GoogleApi20;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.model.Verifier;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import com.google.gson.Gson;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.struts.BaseStrutsAction;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import gr.cite.additionalemailaddresses.CheckAdditionalEmailAddresses;
import gr.cite.google.model.GoogleJson;
import gr.cite.google.util.LoginHookEssentialMethods;
import java.io.IOException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.portal.landingpage.LandingPageManager;

public class GoogleOAuth
extends BaseStrutsAction {
    private static final Log log = LogFactoryUtil.getLog(GoogleOAuth.class);

    public String execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String returnFromGoogleUrl = PortalUtil.getPortalURL((HttpServletRequest)request) + PropsUtil.get((String)"google.hook.callback.url");
        String googleClientId = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"google.client.id", (String)PropsUtil.get((String)"google.client.id"));
        String googleClientSecret = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"google.client.secret", (String)PropsUtil.get((String)"google.client.secret"));
        Boolean canCreateAccount = PrefsPropsUtil.getBoolean((long)themeDisplay.getCompanyId(), (String)"company.security.strangers");
        User user = null;
        String landingPage = "";
        if (ParamUtil.getString((HttpServletRequest)request, (String)"cmd").equals("login")) {
            log.debug((Object)"Initial call for login...");
            this.establishConnectionWithGoogle(session, response, returnFromGoogleUrl, googleClientId, googleClientSecret);
        } else if (ParamUtil.getString((HttpServletRequest)request, (String)"cmd").equals("token")) {
            String oauthCode = ParamUtil.getString((HttpServletRequest)request, (String)"code");
            log.debug((Object)"User gave permision to read data...");
            if (Validator.isNull((String)oauthCode)) {
                return null;
            }
            GoogleJson googleUserInfo = this.retrieveUsersGoogleInfo(oauthCode, returnFromGoogleUrl, googleClientId, googleClientSecret);
            log.debug((Object)("Google's object: " + googleUserInfo));
            if (googleUserInfo == null) {
                throw new LoginException();
            }
            try {
                user = CheckAdditionalEmailAddresses.checkInIfAdditionalEmailAndIfVerified((String)googleUserInfo.getEmail());
            }
            catch (Exception e) {
                log.error((Object)"Error occured while searching in additional emails", (Throwable)e);
                e.printStackTrace();
                throw e;
            }
            if (user != null) {
                log.info((Object)("Email " + googleUserInfo.getEmail() + " has been found in additional Email Addresses"));
                session.setAttribute("userEmailAdressGoogle", (Object)googleUserInfo.getEmail());
            } else if (canCreateAccount.booleanValue()) {
                LoginHookEssentialMethods.addUser((HttpSession)session, (long)themeDisplay.getCompanyId(), (GoogleJson)googleUserInfo);
                user = UserLocalServiceUtil.getUserById((long)UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)googleUserInfo.getEmail()).getUserId());
            } else {
                try {
                    user = UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)googleUserInfo.getEmail());
                    log.debug((Object)("Login user " + user.getFullName() + " email address " + user.getEmailAddress()));
                    session.setAttribute("userEmailAdressGoogle", (Object)user.getEmailAddress());
                }
                catch (PortalException e) {
                    SessionErrors.add((HttpSession)session, NoSuchUserException.class);
                }
            }
            landingPage = LandingPageManager.getLandingPagePath((HttpServletRequest)request, (User)user);
            response.sendRedirect(landingPage);
        }
        return null;
    }

    private void establishConnectionWithGoogle(HttpSession session, HttpServletResponse response, String returnFromGoogleUrl, String googleClientId, String googleClientSecret) throws IOException {
        OAuth20Service service = ((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)new ServiceBuilder().apiKey(googleClientId)).apiSecret(googleClientSecret)).callback(returnFromGoogleUrl)).scope("https://www.googleapis.com/auth/userinfo.email")).build((DefaultApi20)GoogleApi20.instance());
        String googleAuthUrl = service.getAuthorizationUrl();
        response.sendRedirect(googleAuthUrl);
    }

    private GoogleJson retrieveUsersGoogleInfo(String oauthCode, String returnFromGoogleUrl, String googleClientId, String googleClientSecret) {
        OAuth20Service service = ((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)new ServiceBuilder().apiKey(googleClientId)).apiSecret(googleClientSecret)).callback(returnFromGoogleUrl)).scope("https://www.googleapis.com/auth/userinfo.email")).build((DefaultApi20)GoogleApi20.instance());
        Verifier verifier = new Verifier(oauthCode);
        Token accessToken = service.getAccessToken(verifier);
        OAuthRequest authRequest = new OAuthRequest(Verb.GET, "https://www.googleapis.com/oauth2/v2/userinfo", (OAuthService)service);
        service.signRequest(accessToken, (AbstractRequest)authRequest);
        String bodyResponse = authRequest.send().getBody();
        GoogleJson googleJson = (GoogleJson)new Gson().fromJson(bodyResponse, GoogleJson.class);
        return googleJson;
    }
}

