/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.linkedin;

import com.google.gson.Gson;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.struts.BaseStrutsAction;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import gr.cite.linkedin.model.UserInfo;
import gr.cite.linkedin.util.LoginHookEssentialMethods;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.portal.landingpage.LandingPageManager;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.LinkedInApi;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class LinkedInOAuth
extends BaseStrutsAction {
    private static final Log log = LogFactoryUtil.getLog(LinkedInOAuth.class);

    public String execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String redirectUrlCustom = GetterUtil.getString((Object)session.getAttribute("redirectUrlAfterLogin"));
        String redirectUrlDefault = PortalUtil.getPortalURL((HttpServletRequest)request) + PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"default.landing.page.path");
        String returnFromLinkedInUrl = PortalUtil.getPortalURL((HttpServletRequest)request) + PropsUtil.get((String)"linkedIn.api.callback.url");
        String linkedInClientId = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"linkedIn.client.id", (String)PropsUtil.get((String)"linkedIn.client.id"));
        String linkedInClientSecret = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"linkedIn.client.secret", (String)PropsUtil.get((String)"linkedIn.client.secret"));
        Boolean canCreateAccount = PrefsPropsUtil.getBoolean((long)themeDisplay.getCompanyId(), (String)"company.security.strangers");
        User user = null;
        String landingPage = null;
        if (ParamUtil.getString((HttpServletRequest)request, (String)"cmd").equals("login")) {
            log.debug((Object)"Initial call for login...");
            this.setTokenToSessionAndRedirectToLinkedIn(response, session, linkedInClientId, linkedInClientSecret, returnFromLinkedInUrl);
        } else if (ParamUtil.getString((HttpServletRequest)request, (String)"cmd").equals("token")) {
            log.debug((Object)"User gave permision to read data...");
            UserInfo linkedInUserInfo = this.retrieveUsersLinkedInInfo(request, session, linkedInClientId, linkedInClientSecret);
            if (linkedInUserInfo == null) {
                log.debug((Object)"Could not extract data, returning...");
                return null;
            }
            log.debug((Object)("User's first name: " + linkedInUserInfo.getFirstName()));
            log.debug((Object)("User's last name: " + linkedInUserInfo.getLastName()));
            log.debug((Object)("User's email address: " + linkedInUserInfo.getEmailAddress()));
            if (canCreateAccount.booleanValue()) {
                LoginHookEssentialMethods.addUser((HttpSession)session, (long)themeDisplay.getCompanyId(), (UserInfo)linkedInUserInfo);
                user = UserLocalServiceUtil.getUserById((long)UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)linkedInUserInfo.getEmailAddress()).getUserId());
            } else {
                try {
                    user = UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)linkedInUserInfo.getEmailAddress());
                    log.debug((Object)("Login user " + user.getFullName() + " email address " + user.getEmailAddress()));
                    session.setAttribute("userEmailAdressLinkedIn", (Object)user.getEmailAddress());
                }
                catch (PortalException e) {
                    SessionErrors.add((HttpSession)session, NoSuchUserException.class);
                }
            }
            landingPage = LandingPageManager.getLandingPagePath((HttpServletRequest)request, (User)user);
            response.sendRedirect(landingPage);
        }
        return null;
    }

    private void setTokenToSessionAndRedirectToLinkedIn(HttpServletResponse response, HttpSession session, String linkedInClientId, String linkedInClientSecret, String returnFromLinkedInUrl) throws IOException {
        OAuthService service = new ServiceBuilder().provider(LinkedInApi.class).apiKey(linkedInClientId).apiSecret(linkedInClientSecret).callback(returnFromLinkedInUrl).build();
        Token requestToken = service.getRequestToken();
        String linkedInAuthUrl = service.getAuthorizationUrl(requestToken);
        session.setAttribute("requestTokenSecretLinkedIn", (Object)requestToken.getSecret());
        response.sendRedirect(linkedInAuthUrl);
    }

    private UserInfo retrieveUsersLinkedInInfo(HttpServletRequest request, HttpSession session, String linkedInClientId, String linkedInClientSecret) {
        String oauthVerifier = ParamUtil.getString((HttpServletRequest)request, (String)"oauth_verifier");
        String oauthToken = ParamUtil.getString((HttpServletRequest)request, (String)"oauth_token");
        String requestTokenSecret = GetterUtil.getString((Object)session.getAttribute("requestTokenSecretLinkedIn"));
        session.removeAttribute("requestTokenSecretLinkedIn");
        OAuthService service = new ServiceBuilder().provider(LinkedInApi.class).apiKey(linkedInClientId).apiSecret(linkedInClientSecret).build();
        if (Validator.isNull((String)oauthVerifier) || Validator.isNull((String)oauthToken)) {
            return null;
        }
        Verifier v = new Verifier(oauthVerifier);
        Token requestToken = new Token(oauthToken, requestTokenSecret);
        Token accessToken = service.getAccessToken(requestToken, v);
        OAuthRequest authRequest = new OAuthRequest(Verb.GET, "https://api.linkedin.com/v1/people/~:(id,email-address,first-name,last-name)?format=json");
        service.signRequest(accessToken, authRequest);
        String bodyResponse = authRequest.send().getBody();
        UserInfo userInfo = (UserInfo)new Gson().fromJson(bodyResponse, UserInfo.class);
        return userInfo;
    }
}

