/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.windowslive;

import com.github.scribejava.apis.LiveApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.model.Verifier;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import com.google.gson.Gson;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.struts.BaseStrutsAction;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import gr.cite.windowslive.model.WindowsLiveUserInfo;
import gr.cite.windowslive.scribe.OAuthMyService;
import gr.cite.windowslive.scribe.WindowsLiveMyService;
import gr.cite.windowslive.util.LoginHookEssentialMethods;
import gr.cite.windowslive.util.WindowsLiveSpecificMethods;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.portal.landingpage.LandingPageManager;

public class WindowsLiveOAuth
extends BaseStrutsAction {
    private static final Log log = LogFactoryUtil.getLog(WindowsLiveOAuth.class);

    public String execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String returnFromWindowsLiveUrl = PortalUtil.getPortalURL((HttpServletRequest)request) + PropsUtil.get((String)"windowsLive.api.callback.url");
        String windowsLiveClientId = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"windowsLive.client.id", (String)"windowsLive.client.id");
        String windowsLiveClientSecret = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"windowsLive.client.secret", (String)PropsUtil.get((String)"windowsLive.client.secret"));
        Boolean canCreateAccount = PrefsPropsUtil.getBoolean((long)themeDisplay.getCompanyId(), (String)"company.security.strangers");
        String emailAddress = null;
        User user = null;
        String landingPage = null;
        if (ParamUtil.getString((HttpServletRequest)request, (String)"cmd").equals("login")) {
            log.info((Object)"Initial call for login...");
            this.setTokenToSessionAndRedirectToWindowsLive(response, session, windowsLiveClientId, windowsLiveClientSecret, returnFromWindowsLiveUrl);
        } else {
            log.info((Object)"User gave permision to read data...");
            WindowsLiveUserInfo windowsLiveUserInfo = this.retrieveUsersWindowsLiveInfo(request, session, windowsLiveClientId, windowsLiveClientSecret);
            emailAddress = WindowsLiveSpecificMethods.returnEmailAddress((WindowsLiveUserInfo)windowsLiveUserInfo);
            if (windowsLiveUserInfo == null || emailAddress.isEmpty()) {
                log.info((Object)"Could not extract data, returning...");
                return null;
            }
            log.info((Object)("User's first name: " + windowsLiveUserInfo.getFirstName()));
            log.info((Object)("User's last name: " + windowsLiveUserInfo.getLastName()));
            log.info((Object)("User's email address: " + windowsLiveUserInfo.getEmails().getAccount()));
            if (canCreateAccount.booleanValue()) {
                LoginHookEssentialMethods.addUser((HttpSession)session, (long)themeDisplay.getCompanyId(), (WindowsLiveUserInfo)windowsLiveUserInfo);
                user = UserLocalServiceUtil.getUserById((long)UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)windowsLiveUserInfo.getEmails().getAccount()).getUserId());
            } else {
                try {
                    user = UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)windowsLiveUserInfo.getEmails().getAccount());
                    log.debug((Object)("Login user " + user.getFullName() + " email address " + user.getEmailAddress()));
                    session.setAttribute("userEmailAdressWindowsLive", (Object)user.getEmailAddress());
                }
                catch (PortalException e) {
                    SessionErrors.add((HttpSession)session, NoSuchUserException.class);
                }
            }
            landingPage = LandingPageManager.getLandingPagePath((HttpServletRequest)request, (User)user);
            response.sendRedirect(landingPage);
        }
        return null;
    }

    public static Log getLog() {
        return log;
    }

    private void setTokenToSessionAndRedirectToWindowsLive(HttpServletResponse response, HttpSession session, String windowsLiveClientId, String windowsLiveClientSecret, String returnFromWindowsLiveUrl) throws IOException {
        OAuth20Service service = ((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)new ServiceBuilder().apiKey(windowsLiveClientId)).apiSecret(windowsLiveClientSecret)).callback(returnFromWindowsLiveUrl)).scope("wl.emails")).build((DefaultApi20)LiveApi.instance());
        String windowsLiveAuthUrl = service.getAuthorizationUrl();
        response.sendRedirect(windowsLiveAuthUrl);
    }

    private WindowsLiveUserInfo retrieveUsersWindowsLiveInfo(HttpServletRequest request, HttpSession session, String windowsLiveClientId, String windowsLiveClientSecret) {
        String oautCode = ParamUtil.getString((HttpServletRequest)request, (String)"code");
        OAuthMyService service = (OAuthMyService)((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)new ServiceBuilder().apiKey(windowsLiveClientId)).callback(PortalUtil.getPortalURL((HttpServletRequest)request) + PropsUtil.get((String)"windowsLive.api.callback.url"))).apiSecret(windowsLiveClientSecret)).build((DefaultApi20)WindowsLiveMyService.instance());
        if (Validator.isNull((String)oautCode)) {
            return null;
        }
        OAuthRequest authRequest = this.windowsLiveCommunicationForAuth(session, service, oautCode);
        String bodyResponse = authRequest.send().getBody();
        return (WindowsLiveUserInfo)new Gson().fromJson(bodyResponse, WindowsLiveUserInfo.class);
    }

    private OAuthRequest windowsLiveCommunicationForAuth(HttpSession session, OAuthMyService service, String oautCode) {
        session.removeAttribute("requestTokenSecretWindowsLive");
        Verifier v = new Verifier(oautCode);
        Token accessToken = service.getAccessTokenWithPost(v);
        OAuthRequest authrequest = new OAuthRequest(Verb.GET, "https://apis.live.net/v5.0/me", (OAuthService)service);
        service.signRequest(accessToken, (AbstractRequest)authrequest);
        return authrequest;
    }
}

