/**
 * (c) 2014 FAO / UN (project: fi-security-integration)
 */
package org.fao.fi.security.integration.test.support.services.secured.encryption.out;

import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import org.fao.fi.security.server.javax.filters.origin.support.IPRestrictedResource;
import org.fao.fi.security.server.javax.interceptors.support.encryption.EncryptedOutputResource;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 5 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 5 May 2014
 */
@Singleton @IPRestrictedResource @Path("/encryption/out")
public class EchoServiceImplWithOutputEncryption {
	/**
	 * Class constructor
	 *
	 */
	public EchoServiceImplWithOutputEncryption() {
	}
	
	@GET
	@Path("echo/{text}")
	@Produces("text/plain")
	@EncryptedOutputResource public String echo(@PathParam(value="text") String text) throws Throwable {
		return text;
	}
}
