/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.aggregation;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.ResultSet;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.aggregation.AggregationInfo;
import org.gcube.accounting.aggregator.aggregation.AggregatorBuffer;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceFactory;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceSrc;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Constant;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.utility.postgresql.RecordToDBFields;
import org.gcube.accounting.utility.postgresql.RecordToDBMapping;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aggregator {
    private static Logger logger = LoggerFactory.getLogger(Aggregator.class);
    private static final String TMP_SUFFIX = ".tmp";
    protected final AggregationStatus aggregationStatus;
    protected final File originalRecordsbackupFile;
    protected final File aggregateRecordsBackupFile;
    protected final File malformedRecordsFile;
    protected int estimatedRecordsNumber;
    protected int originalRecordsNumber;
    protected int malformedRecordNumber;
    protected ObjectMapper objectMapper;
    protected Calendar startTime;
    protected boolean skipAggregation;
    private static final String USAGE_RECORD_TYPE = "usageRecordType";
    private static final String SINGLE = "Single";
    private static final String SIMPLE = "Simple";
    private static final int MAX_RETRY = 3;

    public Aggregator(AggregationStatus aggregationStatus, File originalRecordsbackupFile, File aggregateRecordsBackupFile) {
        this.aggregationStatus = aggregationStatus;
        this.originalRecordsbackupFile = originalRecordsbackupFile;
        this.aggregateRecordsBackupFile = aggregateRecordsBackupFile;
        this.malformedRecordsFile = Utility.getMalformatedFile(aggregateRecordsBackupFile);
        this.objectMapper = new ObjectMapper();
    }

    public void setSkipAggregation(boolean skipAggregation) {
        this.skipAggregation = skipAggregation;
    }

    public void aggregate() throws Exception {
        if (AggregationState.canContinue(this.aggregationStatus.getAggregationState(), AggregationState.STARTED)) {
            this.startTime = Utility.getUTCCalendarInstance();
            AggregatorPersistenceSrc aggregatorPersistenceSrc = AggregatorPersistenceFactory.getAggregatorPersistenceSrc();
            this.estimatedRecordsNumber = aggregatorPersistenceSrc.getEstimatedRecordRecordToBeAggregated(this.aggregationStatus);
            logger.info("Estimated records to be aggregated are {}", (Object)this.estimatedRecordsNumber);
            ResultSet resultSet = aggregatorPersistenceSrc.getResultSetOfRecordToBeAggregated(this.aggregationStatus);
            this.retrieveAndAggregate(resultSet);
        }
    }

    protected void elaborateRow(ObjectNode content, AggregatorBuffer aggregatorBuffer) throws Exception {
        Double d;
        Double double1;
        JsonNode object;
        if (content.has(USAGE_RECORD_TYPE)) {
            String recordType = content.get(USAGE_RECORD_TYPE).asText();
            content.remove(USAGE_RECORD_TYPE);
            content.put("recordType", recordType);
        }
        Boolean aggregated = false;
        if (content.has("creationTime") && (object = content.get("creationTime")) instanceof Double) {
            d = double1 = (Double)object;
            content.put("creationTime", d.longValue());
        }
        if (content.has("startTime")) {
            aggregated = true;
            object = content.get("startTime");
            if (object instanceof Double) {
                d = double1 = (Double)object;
                content.put("startTime", d.longValue());
            }
        }
        if (content.has("endTime")) {
            aggregated = true;
            object = content.get("endTime");
            if (object instanceof Double) {
                d = double1 = (Double)object;
                content.put("endTime", d.longValue());
            }
        }
        if (content.has("operationCount")) {
            object = content.get("operationCount");
            if (object instanceof Double) {
                d = double1 = (Double)object;
                content.put("operationCount", d.intValue());
            }
            if (content.get("operationCount").asInt() > 1) {
                aggregated = true;
            }
        }
        if (aggregated.booleanValue()) {
            content.put("aggregated", true);
        }
        Object recordType = content.get("recordType").asText();
        if (!aggregated.booleanValue()) {
            if (((String)recordType).startsWith(SIMPLE)) {
                recordType = ((String)recordType).replace(SIMPLE, SINGLE);
                content.put("recordType", (String)recordType);
            }
            if (!((String)recordType).startsWith(SINGLE)) {
                recordType = SINGLE + (String)recordType;
                content.put("recordType", (String)recordType);
            }
        } else {
            if (((String)recordType).startsWith(SIMPLE)) {
                recordType = ((String)recordType).replace(SIMPLE, "");
                content.put("recordType", (String)recordType);
            }
            if (((String)recordType).startsWith(SINGLE)) {
                recordType = ((String)recordType).replace(SINGLE, "");
                content.put("recordType", (String)recordType);
            }
        }
        String record = content.toString();
        if (!this.skipAggregation) {
            this.aggregateRow(aggregatorBuffer, record);
        }
        ++this.originalRecordsNumber;
        if (this.originalRecordsNumber % 1000 == 0) {
            int aggregatedRecordsNumber = 0;
            aggregatedRecordsNumber = !this.skipAggregation ? aggregatorBuffer.getAggregatedRecords().size() : this.originalRecordsNumber;
            int diff = this.originalRecordsNumber - aggregatedRecordsNumber;
            float percentage = 100 * diff / this.originalRecordsNumber;
            logger.info("{} At the moment, the elaborated original records are {} (Total Estimated Number is {}). The Aggregated records are {}. Difference {}. We are recovering {}% of Records", new Object[]{this.aggregationStatus.getAggregationInfo(), this.originalRecordsNumber, this.estimatedRecordsNumber, aggregatedRecordsNumber, diff, Float.valueOf(percentage)});
        }
        Utility.printLine(this.originalRecordsbackupFile, record);
    }

    protected void addProperty(ObjectNode objectNode, String key, Object value) {
        if (value instanceof Number) {
            if (value instanceof Integer) {
                Integer integer = (Integer)value;
                objectNode.put(key, integer);
                return;
            }
            Long longValue = Long.valueOf(value.toString());
            objectNode.put(key, longValue);
            return;
        }
        objectNode.put(key, value.toString());
    }

    protected Calendar getCalendar(OffsetDateTime offsetDateTime) {
        Calendar calendar = Calendar.getInstance();
        long epochMillis = offsetDateTime.toInstant().toEpochMilli();
        calendar.setTimeInMillis(epochMillis);
        return calendar;
    }

    protected void retrieveAndAggregate(ResultSet resultSet) throws Exception {
        AggregatorBuffer aggregatorBuffer = new AggregatorBuffer();
        Calendar start = Utility.getUTCCalendarInstance();
        logger.debug("Elaboration of Records started at {}", (Object)Constant.DEFAULT_DATE_FORMAT.format(start.getTime()));
        this.originalRecordsbackupFile.delete();
        this.aggregateRecordsBackupFile.delete();
        this.malformedRecordsFile.delete();
        AggregationInfo aggregationInfo = this.aggregationStatus.getAggregationInfo();
        String type = aggregationInfo.getRecordType();
        Class clz = RecordUtility.getAggregatedRecordClass((String)type);
        RecordToDBFields recordToDBFields = RecordToDBMapping.getRecordToDBFields((Class)clz);
        Set requiredFields = ((AggregatedRecord)clz.newInstance()).getRequiredFields();
        this.originalRecordsNumber = 0;
        this.malformedRecordNumber = 0;
        block10: while (resultSet.next()) {
            for (int i = 1; i <= 3; ++i) {
                try {
                    ObjectNode objectNode = this.objectMapper.createObjectNode();
                    this.addProperty(objectNode, "recordType", type);
                    for (String recordField : requiredFields) {
                        String tableField = recordToDBFields.getTableField(recordField);
                        Object obj = null;
                        switch (recordField) {
                            case "startTime": 
                            case "endTime": 
                            case "creationTime": {
                                OffsetDateTime offsetDateTime = resultSet.getObject(tableField, OffsetDateTime.class);
                                Calendar calendar = this.getCalendar(offsetDateTime);
                                obj = calendar.getTimeInMillis();
                                break;
                            }
                            default: {
                                obj = resultSet.getObject(tableField);
                            }
                        }
                        this.addProperty(objectNode, recordField, obj);
                    }
                    this.elaborateRow(objectNode, aggregatorBuffer);
                    TimeUnit.MILLISECONDS.sleep(3L);
                    continue block10;
                }
                catch (RuntimeException e) {
                    if (i != 2) continue;
                    logger.error("Unable to elaborate row {}. Tryed {} times.", (Object)i, (Object)e);
                    continue;
                }
            }
        }
        Calendar end = Utility.getUTCCalendarInstance();
        long duration = end.getTimeInMillis() - start.getTimeInMillis();
        String durationForHuman = Utility.getHumanReadableDuration(duration);
        logger.debug("{} Elaboration of Records terminated at {}. Duration {}", new Object[]{this.aggregationStatus.getAggregationInfo(), Constant.DEFAULT_DATE_FORMAT.format(end.getTime()), durationForHuman});
        if (!this.skipAggregation) {
            File aggregateRecordsBackupFileTmp = new File(this.aggregateRecordsBackupFile.getParent(), this.aggregateRecordsBackupFile.getName() + TMP_SUFFIX);
            aggregateRecordsBackupFileTmp.delete();
            logger.debug("Going to save {} to file {}", (Object)AggregatedUsageRecord.class.getSimpleName(), (Object)this.aggregateRecordsBackupFile);
            List<AggregatedRecord<?, ?>> aggregatedRecords = aggregatorBuffer.getAggregatedRecords();
            for (AggregatedRecord aggregatedRecord : aggregatedRecords) {
                String marshalled = DSMapper.marshal((Record)aggregatedRecord);
                Utility.printLine(aggregateRecordsBackupFileTmp, marshalled);
            }
            aggregateRecordsBackupFileTmp.renameTo(this.aggregateRecordsBackupFile);
            this.aggregationStatus.setRecordNumbers(this.originalRecordsNumber, aggregatedRecords.size(), this.malformedRecordNumber);
        } else {
            Files.copy(this.originalRecordsbackupFile.toPath(), this.aggregateRecordsBackupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.aggregationStatus.setRecordNumbers(this.originalRecordsNumber, this.originalRecordsNumber, this.malformedRecordNumber);
        }
        this.aggregationStatus.setAggregationState(AggregationState.AGGREGATED, this.startTime, true);
    }

    protected void aggregateRow(AggregatorBuffer aggregatorBuffer, String json) throws Exception {
        Record record = RecordUtility.getRecord((String)json);
        try {
            record.validate();
        }
        catch (InvalidValueException e) {
            ++this.malformedRecordNumber;
            Utility.printLine(this.malformedRecordsFile, json);
            if (record instanceof AggregatedServiceUsageRecord) {
                try {
                    if (record.getResourceProperty("minInvocationTime") == null) {
                        record.setResourceProperty("minInvocationTime", record.getResourceProperty("duration"));
                    }
                    if (record.getResourceProperty("maxInvocationTime") == null) {
                        record.setResourceProperty("maxInvocationTime", record.getResourceProperty("duration"));
                    }
                    if (record.getResourceProperty("callerQualifier") == null) {
                        record.setResourceProperty("callerQualifier", (Serializable)((Object)"UNKNOWN"));
                    }
                    record.validate();
                }
                catch (Exception ex) {
                    return;
                }
            }
            return;
        }
        record.setId(UUID.randomUUID().toString());
        AggregatedRecord aggregatedRecord = AggregatorBuffer.getAggregatedRecord(record);
        aggregatorBuffer.aggregate(aggregatedRecord);
    }
}

