/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.aggregation;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.documentstore.records.aggregation.AggregationUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorBuffer {
    public static Logger logger = LoggerFactory.getLogger(AggregatorBuffer.class);
    protected List<AggregatedRecord<?, ?>> aggregatedRecords = new ArrayList();

    protected static AggregatedRecord instantiateAggregatedRecord(Record record) throws Exception {
        String recordType = record.getRecordType();
        Class clz = RecordUtility.getAggregatedRecordClass((String)recordType);
        Class[] argTypes = new Class[]{record.getClass()};
        Constructor constructor = clz.getDeclaredConstructor(argTypes);
        Object[] arguments = new Object[]{record};
        return (AggregatedRecord)constructor.newInstance(arguments);
    }

    public static AggregatedRecord getAggregatedRecord(Record record) throws Exception {
        AggregatedRecord aggregatedRecord1;
        AggregatedRecord aggregatedRecord = record instanceof AggregatedRecord ? (aggregatedRecord1 = (AggregatedRecord)record) : AggregatorBuffer.instantiateAggregatedRecord(record);
        return aggregatedRecord;
    }

    protected void madeAggregation(AggregatedRecord<?, ?> record) throws InvalidValueException {
        boolean found = false;
        for (AggregatedRecord<?, ?> aggregatedRecord : this.aggregatedRecords) {
            AggregationUtility aggregationUtility;
            if (!(aggregatedRecord instanceof AggregatedRecord) || !(aggregationUtility = new AggregationUtility(aggregatedRecord)).isAggregable(record)) continue;
            try {
                Calendar aggregatedRecordCreationTime = aggregatedRecord.getCreationTime();
                Calendar recordCreationTime = record.getCreationTime();
                Calendar creationtime = aggregatedRecordCreationTime.before(recordCreationTime) ? aggregatedRecordCreationTime : recordCreationTime;
                aggregatedRecord.aggregate(record);
                aggregatedRecord.setCreationTime(creationtime);
                found = true;
                break;
            }
            catch (NotAggregatableRecordsExceptions e) {
                logger.debug("{} is not usable for aggregation", aggregatedRecord);
            }
        }
        if (!found) {
            this.aggregatedRecords.add(record);
            return;
        }
    }

    public List<AggregatedRecord<?, ?>> getAggregatedRecords() {
        return this.aggregatedRecords;
    }

    public void aggregate(AggregatedRecord<?, ?> record) throws Exception {
        if (record != null) {
            this.madeAggregation(record);
        }
    }
}

