/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import com.couchbase.client.java.subdoc.DocumentFragment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class N1qlParams
implements Serializable {
    private static final long serialVersionUID = 8888370260267213830L;
    private String serverSideTimeout;
    private ScanConsistency consistency;
    private String scanWait;
    private String clientContextId;
    private Integer maxParallelism;
    private List<MutationToken> mutationTokens;
    private boolean adhoc = true;

    private N1qlParams() {
    }

    public void injectParams(JsonObject queryJson) {
        if (this.serverSideTimeout != null) {
            queryJson.put("timeout", this.serverSideTimeout);
        }
        if (this.consistency != null) {
            queryJson.put("scan_consistency", this.consistency.n1ql());
        }
        if (this.scanWait != null && (ScanConsistency.REQUEST_PLUS == this.consistency || ScanConsistency.STATEMENT_PLUS == this.consistency)) {
            queryJson.put("scan_wait", this.scanWait);
        }
        if (this.clientContextId != null) {
            queryJson.put("client_context_id", this.clientContextId);
        }
        if (this.maxParallelism != null) {
            queryJson.put("max_parallelism", this.maxParallelism.toString());
        }
        if (this.mutationTokens != null) {
            if (this.consistency != null) {
                throw new IllegalArgumentException("`consistency(...)` cannot be used together with `consistentWith(...)`");
            }
            JsonObject vectors = JsonObject.create();
            for (MutationToken token : this.mutationTokens) {
                JsonObject bucket = vectors.getObject(token.bucket());
                if (bucket == null) {
                    bucket = JsonObject.create();
                    vectors.put(token.bucket(), bucket);
                }
                bucket.put(String.valueOf(token.vbucketID()), JsonArray.from(token.sequenceNumber(), String.valueOf(token.vbucketUUID())));
            }
            queryJson.put("scan_vectors", vectors);
            queryJson.put("scan_consistency", "at_plus");
        }
    }

    private static String durationToN1qlFormat(long duration, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return duration + "ns";
            }
            case MICROSECONDS: {
                return duration + "us";
            }
            case MILLISECONDS: {
                return duration + "ms";
            }
            case SECONDS: {
                return duration + "s";
            }
            case MINUTES: {
                return duration + "m";
            }
            case HOURS: {
                return duration + "h";
            }
        }
        return unit.toHours(duration) + "h";
    }

    public static N1qlParams build() {
        return new N1qlParams();
    }

    public N1qlParams serverSideTimeout(long timeout, TimeUnit unit) {
        this.serverSideTimeout = N1qlParams.durationToN1qlFormat(timeout, unit);
        return this;
    }

    public N1qlParams withContextId(String clientContextId) {
        this.clientContextId = clientContextId;
        return this;
    }

    public N1qlParams consistency(ScanConsistency consistency) {
        this.consistency = consistency;
        if (consistency == ScanConsistency.NOT_BOUNDED) {
            this.scanWait = null;
        }
        return this;
    }

    @InterfaceStability.Experimental
    public N1qlParams consistentWith(Document ... documents) {
        if (documents == null || documents.length == 0) {
            throw new IllegalArgumentException("At least one Document needs to be provided.");
        }
        for (Document doc : documents) {
            this.storeToken(doc.mutationToken());
        }
        return this;
    }

    @InterfaceStability.Experimental
    public N1qlParams consistentWith(DocumentFragment ... fragments) {
        if (fragments == null || fragments.length == 0) {
            throw new IllegalArgumentException("At least one DocumentFragment needs to be provided.");
        }
        for (DocumentFragment doc : fragments) {
            this.storeToken(doc.mutationToken());
        }
        return this;
    }

    private void storeToken(MutationToken token) {
        if (token == null) {
            throw new IllegalArgumentException("No MutationToken provided (must be enabled on the Environment).");
        }
        if (this.mutationTokens == null) {
            this.mutationTokens = new ArrayList<MutationToken>();
            this.mutationTokens.add(token);
            return;
        }
        Iterator<MutationToken> tokenIterator = this.mutationTokens.iterator();
        while (tokenIterator.hasNext()) {
            MutationToken t = tokenIterator.next();
            if (t.vbucketID() != token.vbucketID() || !t.bucket().equals(token.bucket())) continue;
            if (token.sequenceNumber() > t.sequenceNumber()) {
                tokenIterator.remove();
                this.mutationTokens.add(token);
            }
            return;
        }
        this.mutationTokens.add(token);
    }

    public N1qlParams scanWait(long wait, TimeUnit unit) {
        this.scanWait = this.consistency == ScanConsistency.NOT_BOUNDED ? null : N1qlParams.durationToN1qlFormat(wait, unit);
        return this;
    }

    public N1qlParams maxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
        return this;
    }

    public N1qlParams adhoc(boolean adhoc) {
        this.adhoc = adhoc;
        return this;
    }

    public boolean hasServerSideTimeout() {
        return this.serverSideTimeout != null;
    }

    public boolean isAdhoc() {
        return this.adhoc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        N1qlParams that = (N1qlParams)o;
        if (this.adhoc != that.adhoc) {
            return false;
        }
        if (this.serverSideTimeout != null ? !this.serverSideTimeout.equals(that.serverSideTimeout) : that.serverSideTimeout != null) {
            return false;
        }
        if (this.consistency != that.consistency) {
            return false;
        }
        if (this.scanWait != null ? !this.scanWait.equals(that.scanWait) : that.scanWait != null) {
            return false;
        }
        if (this.clientContextId != null ? !this.clientContextId.equals(that.clientContextId) : that.clientContextId != null) {
            return false;
        }
        return !(this.maxParallelism == null ? that.maxParallelism != null : !this.maxParallelism.equals(that.maxParallelism));
    }

    public int hashCode() {
        int result = this.serverSideTimeout != null ? this.serverSideTimeout.hashCode() : 0;
        result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
        result = 31 * result + (this.scanWait != null ? this.scanWait.hashCode() : 0);
        result = 31 * result + (this.clientContextId != null ? this.clientContextId.hashCode() : 0);
        result = 31 * result + (this.maxParallelism != null ? this.maxParallelism.hashCode() : 0);
        result = 31 * result + (this.adhoc ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("N1qlParams{");
        sb.append("serverSideTimeout='").append(this.serverSideTimeout).append('\'');
        sb.append(", consistency=").append((Object)this.consistency);
        sb.append(", scanWait='").append(this.scanWait).append('\'');
        sb.append(", clientContextId='").append(this.clientContextId).append('\'');
        sb.append(", maxParallelism=").append(this.maxParallelism);
        sb.append(", adhoc=").append(this.adhoc);
        sb.append('}');
        return sb.toString();
    }
}

