/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.endpoint.util.WhitespaceSkipper;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class TranscoderUtils {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(TranscoderUtils.class);
    public static final int COMMON_FORMAT_MASK = 0xF000000;
    public static final int PRIVATE_COMMON_FLAGS = TranscoderUtils.createCommonFlags(CommonFlags.PRIVATE.ordinal());
    public static final int JSON_COMMON_FLAGS = TranscoderUtils.createCommonFlags(CommonFlags.JSON.ordinal());
    public static final int BINARY_COMMON_FLAGS = TranscoderUtils.createCommonFlags(CommonFlags.BINARY.ordinal());
    public static final int STRING_COMMON_FLAGS = TranscoderUtils.createCommonFlags(CommonFlags.STRING.ordinal());
    public static final int SERIALIZED_LEGACY_FLAGS = 1;
    public static final int BINARY_LEGACY_FLAGS = 2048;
    public static final int STRING_LEGACY_FLAGS = 0;
    public static final int JSON_LEGACY_FLAGS = 0;
    public static final int BOOLEAN_LEGACY_FLAGS = 0;
    public static final int LONG_LEGACY_FLAGS = 0;
    public static final int DOUBLE_LEGACY_FLAGS = 0;
    public static final int SERIALIZED_COMPAT_FLAGS = PRIVATE_COMMON_FLAGS | 1;
    public static final int JSON_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int BINARY_COMPAT_FLAGS = BINARY_COMMON_FLAGS | 0x800;
    public static final int BOOLEAN_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int LONG_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int DOUBLE_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int STRING_COMPAT_FLAGS = STRING_COMMON_FLAGS | 0;

    public static boolean hasCommonFlags(int flags) {
        return flags >> 24 > 0;
    }

    public static boolean hasCompressionFlags(int flags) {
        return flags >> 29 > 0;
    }

    public static boolean hasCommonFormat(int flags, int expectedCommonFlag) {
        return TranscoderUtils.hasCommonFlags(flags) && (flags & 0xF000000) == expectedCommonFlag;
    }

    public static int extractCommonFlags(int flags) {
        return flags >> 24;
    }

    public static int createCommonFlags(int flags) {
        return flags << 24;
    }

    private static boolean hasFlags(int flags, int expectedCommonFlags, int expectedLegacyFlag) {
        return TranscoderUtils.hasCommonFormat(flags, expectedCommonFlags) || flags == expectedLegacyFlag;
    }

    public static boolean hasJsonFlags(int flags) {
        return TranscoderUtils.hasFlags(flags, JSON_COMMON_FLAGS, 0);
    }

    public static boolean hasStringFlags(int flags) {
        return TranscoderUtils.hasFlags(flags, STRING_COMMON_FLAGS, 0);
    }

    public static boolean hasSerializableFlags(int flags) {
        return TranscoderUtils.hasFlags(flags, PRIVATE_COMMON_FLAGS, 1);
    }

    public static boolean hasBinaryFlags(int flags) {
        return TranscoderUtils.hasFlags(flags, BINARY_COMMON_FLAGS, 2048);
    }

    public static Serializable deserialize(ByteBuf content) throws Exception {
        byte[] serialized = new byte[content.readableBytes()];
        content.getBytes(0, serialized);
        ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
        ObjectInputStream is = new ObjectInputStream(bis);
        Serializable deserialized = (Serializable)is.readObject();
        is.close();
        bis.close();
        return deserialized;
    }

    public static ByteBuf serialize(Serializable serializable) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(serializable);
        byte[] serialized = bos.toByteArray();
        os.close();
        bos.close();
        return Unpooled.buffer().writeBytes(serialized);
    }

    public static ByteBuf encodeStringAsUtf8(String source) {
        ByteBuf target = Unpooled.buffer(source.length());
        ByteBufUtil.writeUtf8(target, (CharSequence)source);
        return target;
    }

    public static ByteBufToArray byteBufToByteArray(ByteBuf input) {
        byte[] inputBytes;
        int offset = 0;
        int length = input.readableBytes();
        if (input.hasArray()) {
            inputBytes = input.array();
            offset = input.arrayOffset() + input.readerIndex();
        } else {
            inputBytes = new byte[length];
            input.getBytes(input.readerIndex(), inputBytes);
        }
        return new ByteBufToArray(inputBytes, offset, length);
    }

    public static <T> T byteBufToClass(ByteBuf input, Class<? extends T> clazz, ObjectMapper mapper) throws IOException {
        ByteBufToArray toArray = TranscoderUtils.byteBufToByteArray(input);
        return mapper.readValue(toArray.byteArray, toArray.offset, toArray.length, clazz);
    }

    public static Object byteBufToGenericObject(ByteBuf input, ObjectMapper mapper) throws IOException {
        int toSkip = input.forEachByte(new WhitespaceSkipper());
        if (toSkip > 0) {
            input.skipBytes(toSkip);
        }
        input.markReaderIndex();
        byte first = input.readByte();
        input.resetReaderIndex();
        switch (first) {
            case 123: {
                return TranscoderUtils.byteBufToClass(input, JsonObject.class, mapper);
            }
            case 91: {
                return TranscoderUtils.byteBufToClass(input, JsonArray.class, mapper);
            }
        }
        Object value = TranscoderUtils.byteBufToClass(input, Object.class, mapper);
        if (value instanceof Map) {
            LOGGER.warn("A JSON object could not be fast detected (first byte '" + (char)first + "')");
            return JsonObject.from((Map)value);
        }
        if (value instanceof List) {
            LOGGER.warn("A JSON array could not be fast detected (first byte '" + (char)first + "')");
            return JsonArray.from((List)value);
        }
        return value;
    }

    public static enum CommonFlags {
        RESERVED,
        PRIVATE,
        JSON,
        BINARY,
        STRING;

    }

    public static class ByteBufToArray {
        public final byte[] byteArray;
        public final int offset;
        public final int length;

        public ByteBufToArray(byte[] byteArray, int offset, int length) {
            this.byteArray = byteArray;
            this.offset = offset;
            this.length = length;
        }
    }
}

