/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;

public class Info {
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
    protected Calendar calendar;
    protected JsonNode value;

    public static DateFormat getDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_PATTERN);
        simpleDateFormat.setTimeZone(TemporalConstraint.DEFAULT_TIME_ZONE);
        return simpleDateFormat;
    }

    public static String format(Calendar calendar) {
        return Info.getDateFormat().format(calendar.getTime());
    }

    public Info(Calendar calendar, JsonNode value) {
        this.calendar = calendar;
        this.value = value;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public JsonNode getValue() {
        return this.value;
    }

    public void setValue(JsonNode value) {
        this.value = value;
    }

    public String toString() {
        return String.format("Date : %s, Value : %s", Info.format(this.calendar), this.value.toString());
    }
}

