/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.activity.InvalidActivityException;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.exception.DuplicatedKeyFilterException;
import org.gcube.accounting.analytics.exception.KeyException;
import org.gcube.accounting.analytics.exception.ValueException;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryFactory;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageStatusRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;

public class AccountingPersistenceQuery
implements AccountingPersistenceBackendQuery {
    private static final AccountingPersistenceQuery accountingPersistenceQuery;
    public static final int DEFAULT_LIMIT_RESULT_NUMBER = 5;
    protected Class<? extends AggregatedRecord<?, ?>> clz;
    protected TemporalConstraint temporalConstraint;
    protected Set<String> contexts;
    protected Collection<? extends Filter> filters;
    protected ObjectMapper objectMapper;
    protected AccountingPersistenceBackendQuery accountingPersistenceBackendQuery = AccountingPersistenceBackendQueryFactory.getInstance();

    protected static synchronized AccountingPersistenceQuery getInstance() {
        return accountingPersistenceQuery;
    }

    private AccountingPersistenceQuery() throws Exception {
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public void setRequestedRecords(Class<? extends AggregatedRecord<?, ?>> clz) {
        this.clz = clz;
        this.accountingPersistenceBackendQuery.setRequestedRecords(clz);
    }

    @Override
    public void setTemporalConstraint(TemporalConstraint temporalConstraint) {
        this.temporalConstraint = temporalConstraint;
        this.accountingPersistenceBackendQuery.setTemporalConstraint(temporalConstraint);
    }

    @Override
    public void setContexts(Set<String> contexts) {
        this.contexts = contexts;
        this.accountingPersistenceBackendQuery.setContexts(this.contexts);
    }

    @Override
    public void setFilters(Collection<? extends Filter> filters) {
        this.filters = filters;
        this.accountingPersistenceBackendQuery.setFilters(filters);
    }

    public static SortedSet<String> getQuerableKeys(Class<? extends AggregatedRecord<?, ?>> clz) throws Exception {
        AggregatedRecord<?, ?> instance = clz.newInstance();
        if (clz.equals(AggregatedStorageStatusRecord.class)) {
            TreeSet<String> storageStatus = new TreeSet<String>();
            storageStatus.add("consumerId");
            return storageStatus;
        }
        return instance.getQuerableKeys();
    }

    public static String getDefaultOrderingProperties(Class<? extends AggregatedRecord<?, ?>> clz) {
        if (clz.isAssignableFrom(AggregatedStorageUsageRecord.class)) {
            return "dataVolume";
        }
        return "operationCount";
    }

    protected JsonNode getPaddingJsonNode(Map<Calendar, Info> unpaddedResults) throws Exception {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        if (unpaddedResults.size() != 0) {
            Info auxInfo = new ArrayList<Info>(unpaddedResults.values()).get(0);
            JsonNode auxJsonNode = auxInfo.getValue();
            Iterator keys = auxJsonNode.fieldNames();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                objectNode.put(key, 0);
            }
        } else {
            Set keys = this.clz.newInstance().getAggregatedFields();
            Iterator iterator = keys.iterator();
            block11: while (iterator.hasNext()) {
                String key;
                switch (key = (String)iterator.next()) {
                    case "startTime": {
                        continue block11;
                    }
                    case "endTime": {
                        continue block11;
                    }
                    case "aggregated": {
                        continue block11;
                    }
                }
                objectNode.put(key, 0);
            }
        }
        return objectNode;
    }

    protected SortedMap<Calendar, Info> padMap(SortedMap<Calendar, Info> unpaddedData) throws Exception {
        JsonNode jsonNode = this.getPaddingJsonNode(unpaddedData);
        SortedSet<Calendar> sequence = this.temporalConstraint.getCalendarSequence();
        for (Calendar progressTime : sequence) {
            Info info = (Info)unpaddedData.get(progressTime);
            if (info != null) continue;
            ObjectNode objectNode = (ObjectNode)jsonNode.deepCopy();
            objectNode.put("startTime", Info.format(progressTime));
            info = new Info(progressTime, (JsonNode)objectNode);
            unpaddedData.put(progressTime, info);
        }
        return unpaddedData;
    }

    @Override
    public SortedMap<Calendar, Info> getTimeSeries() throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        return this.getTimeSeries(true);
    }

    public SortedMap<Calendar, Info> getTimeSeries(boolean pad) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        SortedMap<Calendar, Info> ret = this.accountingPersistenceBackendQuery.getTimeSeries();
        if (ret == null) {
            ret = new TreeMap<Calendar, Info>();
        }
        if (pad) {
            ret = this.padMap(ret);
        }
        return ret;
    }

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(String topKey, String orderingProperty, boolean pad, Integer limit) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        SortedMap<NumberedFilter, SortedMap<Calendar, Info>> got;
        if (orderingProperty == null) {
            orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(this.clz);
        }
        int count = (got = this.accountingPersistenceBackendQuery.getTopValues(topKey, orderingProperty, limit)).size() > limit ? limit.intValue() : got.size();
        NumberedFilter firstRemovalKey = null;
        for (NumberedFilter nf : got.keySet()) {
            if (--count >= 0 || limit <= 0) {
                if (!pad) continue;
                this.padMap((SortedMap)got.get(nf));
                continue;
            }
            if (firstRemovalKey != null) break;
            firstRemovalKey = nf;
        }
        if (firstRemovalKey != null) {
            return got.subMap(got.firstKey(), firstRemovalKey);
        }
        return got;
    }

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(String topKey) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        String orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(this.clz);
        return this.getTopValues(topKey, orderingProperty, false, null);
    }

    @Override
    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(String topKey, String orderingProperty, Integer limit) throws Exception {
        return this.getTopValues(topKey, orderingProperty, false, limit);
    }

    @Override
    public void close() throws Exception {
        AccountingPersistenceBackendQueryFactory.getInstance().close();
    }

    @Override
    public void prepareConnection(AccountingPersistenceBackendQueryConfiguration configuration) throws Exception {
        throw new InvalidActivityException();
    }

    @Override
    public SortedSet<NumberedFilter> getFilterValues(String key) throws Exception {
        return this.getFilterValues(key, null);
    }

    @Override
    public SortedSet<NumberedFilter> getFilterValues(String key, Integer limit) throws Exception {
        return this.accountingPersistenceBackendQuery.getFilterValues(key, limit);
    }

    @Override
    public List<UsageValue> getUsageValueQuotaTotal(List<UsageValue> listUsage) throws Exception {
        return this.accountingPersistenceBackendQuery.getUsageValueQuotaTotal(listUsage);
    }

    @Override
    public SortedMap<Filter, SortedMap<Calendar, Info>> getContextTimeSeries() throws Exception {
        return this.getContextTimeSeries(true);
    }

    public SortedMap<Filter, SortedMap<Calendar, Info>> getContextTimeSeries(boolean pad) throws DuplicatedKeyFilterException, Exception {
        SortedMap<Filter, SortedMap<Calendar, Info>> got = this.accountingPersistenceBackendQuery.getContextTimeSeries();
        int count = got.size();
        Filter firstRemovalKey = null;
        for (Filter nf : got.keySet()) {
            if (--count >= 0) {
                if (!pad) continue;
                this.padMap((SortedMap)got.get(nf));
                continue;
            }
            if (firstRemovalKey != null) break;
            firstRemovalKey = nf;
        }
        if (firstRemovalKey != null) {
            return got.subMap(got.firstKey(), firstRemovalKey);
        }
        return got;
    }

    @Override
    public Record getRecord(String recordId, String type) throws Exception {
        Record record = AccountingPersistenceBackendQueryFactory.getInstance().getRecord(recordId, type);
        return record;
    }

    public SortedSet<String> getDataType() throws Exception {
        TreeSet<String> dataTypes = new TreeSet<String>();
        for (AbstractStorageUsageRecord.DataType dataType : AbstractStorageUsageRecord.DataType.values()) {
            dataTypes.add(dataType.name());
        }
        return dataTypes;
    }

    @Override
    public SortedMap<Filter, SortedMap<Calendar, Info>> getSpaceTimeSeries(Set<String> dataTypes) throws Exception {
        SortedMap<Filter, SortedMap<Calendar, Info>> spaceTimeSeries = this.accountingPersistenceBackendQuery.getSpaceTimeSeries(dataTypes);
        int count = spaceTimeSeries.size();
        Filter firstRemovalKey = null;
        for (Filter nf : spaceTimeSeries.keySet()) {
            if (--count >= 0) {
                this.padMapStorage((SortedMap)spaceTimeSeries.get(nf));
                continue;
            }
            if (firstRemovalKey != null) break;
            firstRemovalKey = nf;
        }
        if (firstRemovalKey != null) {
            return spaceTimeSeries.subMap(spaceTimeSeries.firstKey(), firstRemovalKey);
        }
        return spaceTimeSeries;
    }

    protected SortedMap<Calendar, Info> padMapStorage(SortedMap<Calendar, Info> unpaddedData) throws Exception {
        SortedSet<Calendar> sequence = this.temporalConstraint.getCalendarSequence();
        Info previuosInfo = null;
        for (Calendar progressTime : sequence) {
            Info info = (Info)unpaddedData.get(progressTime);
            if (info == null) {
                unpaddedData.put(progressTime, previuosInfo);
                continue;
            }
            previuosInfo = info;
        }
        return unpaddedData;
    }

    @Override
    public boolean isConnectionActive() throws Exception {
        return AccountingPersistenceBackendQueryFactory.getInstance().isConnectionActive();
    }

    static {
        try {
            accountingPersistenceQuery = new AccountingPersistenceQuery();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

